-- --------------------------------------------------------
-- Host:                         127.0.0.1
-- Server version:               8.0.30 - MySQL Community Server - GPL
-- Server OS:                    Win64
-- HeidiSQL Version:             12.1.0.6537
-- --------------------------------------------------------

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET NAMES utf8 */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

-- Dumping structure for table candy_exam.agama
CREATE TABLE IF NOT EXISTS `agama` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `nama` varchar(100) COLLATE utf8mb4_general_ci NOT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table candy_exam.agama: ~0 rows (approximately)

-- Dumping structure for table candy_exam.bank_soal
CREATE TABLE IF NOT EXISTS `bank_soal` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `kode` varchar(50) COLLATE utf8mb4_general_ci NOT NULL,
  `nama` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
  `deskripsi` text COLLATE utf8mb4_general_ci,
  `created_by` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `is_public` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `kode` (`kode`),
  KEY `created_by` (`created_by`),
  CONSTRAINT `bank_soal_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table candy_exam.bank_soal: ~0 rows (approximately)

-- Dumping structure for table candy_exam.exambro_block
CREATE TABLE IF NOT EXISTS `exambro_block` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `package_name` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
  `app_name` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `category` varchar(50) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `is_blocked` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table candy_exam.exambro_block: ~0 rows (approximately)

-- Dumping structure for table candy_exam.exambro_menu
CREATE TABLE IF NOT EXISTS `exambro_menu` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(100) COLLATE utf8mb4_general_ci NOT NULL,
  `link` text COLLATE utf8mb4_general_ci NOT NULL,
  `icon` varchar(50) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `order` int NOT NULL DEFAULT '0',
  `token` varchar(50) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `is_token` tinyint(1) NOT NULL DEFAULT '1',
  `tgl_dibuka` datetime DEFAULT NULL,
  `tgl_ditutup` datetime DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table candy_exam.exambro_menu: ~0 rows (approximately)

-- Dumping structure for table candy_exam.hasil_ujian
CREATE TABLE IF NOT EXISTS `hasil_ujian` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `ujian_id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `peserta_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `guest_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `waktu_mulai` datetime DEFAULT NULL,
  `waktu_selesai` datetime DEFAULT NULL,
  `nilai_pg` double NOT NULL DEFAULT '0',
  `nilai_esai` double NOT NULL DEFAULT '0',
  `nilai_total` double NOT NULL DEFAULT '0',
  `soal_benar` int NOT NULL DEFAULT '0',
  `soal_salah` int NOT NULL DEFAULT '0',
  `kosong` int NOT NULL DEFAULT '0',
  `poin_benar` int NOT NULL DEFAULT '0',
  `poin_salah` int NOT NULL DEFAULT '0',
  `poin_maksimal` int NOT NULL DEFAULT '0',
  `jawaban_json` text COLLATE utf8mb4_general_ci,
  `urutan_soal` json DEFAULT NULL,
  `urutan_opsi` json DEFAULT NULL,
  `device_id` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `token_valid` tinyint(1) NOT NULL DEFAULT '0',
  `is_device_active` tinyint(1) NOT NULL DEFAULT '0',
  `status` enum('belum_mulai','sedang_ujian','selesai') COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'belum_mulai',
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ujian_id_peserta_id` (`ujian_id`,`peserta_id`),
  KEY `ujian_id` (`ujian_id`),
  KEY `peserta_id` (`peserta_id`),
  CONSTRAINT `hasil_ujian_peserta_id_foreign` FOREIGN KEY (`peserta_id`) REFERENCES `peserta` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `hasil_ujian_ujian_id_foreign` FOREIGN KEY (`ujian_id`) REFERENCES `ujian` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table candy_exam.hasil_ujian: ~0 rows (approximately)

-- Dumping structure for table candy_exam.jawaban
CREATE TABLE IF NOT EXISTS `jawaban` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `ujian_id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `peserta_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `guest_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `soal_id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `jawaban` text COLLATE utf8mb4_general_ci,
  `skor` float DEFAULT '0',
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `jawaban_peserta_id_foreign` (`peserta_id`),
  KEY `jawaban_soal_id_foreign` (`soal_id`),
  KEY `ujian_id_peserta_id_soal_id` (`ujian_id`,`peserta_id`,`soal_id`),
  CONSTRAINT `jawaban_peserta_id_foreign` FOREIGN KEY (`peserta_id`) REFERENCES `peserta` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `jawaban_soal_id_foreign` FOREIGN KEY (`soal_id`) REFERENCES `soal` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `jawaban_ujian_id_foreign` FOREIGN KEY (`ujian_id`) REFERENCES `ujian` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table candy_exam.jawaban: ~0 rows (approximately)

-- Dumping structure for table candy_exam.jurusan
CREATE TABLE IF NOT EXISTS `jurusan` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `nama` varchar(100) COLLATE utf8mb4_general_ci NOT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table candy_exam.jurusan: ~0 rows (approximately)

-- Dumping structure for table candy_exam.kelas
CREATE TABLE IF NOT EXISTS `kelas` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `nama` varchar(100) COLLATE utf8mb4_general_ci NOT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table candy_exam.kelas: ~0 rows (approximately)

-- Dumping structure for table candy_exam.media_files
CREATE TABLE IF NOT EXISTS `media_files` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `path` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
  `type` enum('image','audio','video') COLLATE utf8mb4_general_ci NOT NULL,
  `mime_type` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `used_in_soal` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `media_files_used_in_soal_foreign` (`used_in_soal`),
  CONSTRAINT `media_files_used_in_soal_foreign` FOREIGN KEY (`used_in_soal`) REFERENCES `soal` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table candy_exam.media_files: ~0 rows (approximately)

-- Dumping structure for table candy_exam.migrations
CREATE TABLE IF NOT EXISTS `migrations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `version` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
  `class` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
  `group` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
  `namespace` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
  `time` int NOT NULL,
  `batch` int unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table candy_exam.migrations: ~0 rows (approximately)
INSERT INTO `migrations` (`id`, `version`, `class`, `group`, `namespace`, `time`, `batch`) VALUES
	(1, '2025-06-17-132907', 'App\\Database\\Migrations\\CreateUsersTable', 'default', 'App', 1757809987, 1),
	(2, '2025-06-17-154413', 'App\\Database\\Migrations\\CreateSettingsTable', 'default', 'App', 1757809987, 1),
	(3, '2025-06-17-173834', 'App\\Database\\Migrations\\CreateSettingsExambroTable', 'default', 'App', 1757809987, 1),
	(4, '2025-06-19-223119', 'App\\Database\\Migrations\\CreateExambroMenuTable', 'default', 'App', 1757809987, 1),
	(5, '2025-06-19-223542', 'App\\Database\\Migrations\\CreateExambroBlockTable', 'default', 'App', 1757809987, 1),
	(6, '2025-06-28-143214', 'App\\Database\\Migrations\\CreatePesertaTable', 'default', 'App', 1757809987, 1),
	(7, '2025-06-28-143320', 'App\\Database\\Migrations\\CreateBankSoalTable', 'default', 'App', 1757809987, 1),
	(8, '2025-06-28-143342', 'App\\Database\\Migrations\\CreateUjianTable', 'default', 'App', 1757809987, 1),
	(9, '2025-06-28-143453', 'App\\Database\\Migrations\\CreateSoalTable', 'default', 'App', 1757809987, 1),
	(10, '2025-06-28-143520', 'App\\Database\\Migrations\\CreateJawabanTable', 'default', 'App', 1757809987, 1),
	(11, '2025-06-28-143630', 'App\\Database\\Migrations\\CreateHasilUjianTable', 'default', 'App', 1757809987, 1),
	(12, '2025-06-29-031819', 'App\\Database\\Migrations\\CreateSoalOpsiTable', 'default', 'App', 1757809987, 1),
	(13, '2025-06-29-135202', 'App\\Database\\Migrations\\CreateTingkatTable', 'default', 'App', 1757809987, 1),
	(14, '2025-06-29-135214', 'App\\Database\\Migrations\\CreateKelasTable', 'default', 'App', 1757809987, 1),
	(15, '2025-06-29-135220', 'App\\Database\\Migrations\\CreateJurusanTable', 'default', 'App', 1757809987, 1),
	(16, '2025-06-29-135233', 'App\\Database\\Migrations\\CreateAgamaTable', 'default', 'App', 1757809987, 1),
	(17, '2025-07-02-121837', 'App\\Database\\Migrations\\CreateTopikSoal', 'default', 'App', 1757809987, 1),
	(18, '2025-07-10-134638', 'App\\Database\\Migrations\\CreateMediaFilesTable', 'default', 'App', 1757809987, 1);

-- Dumping structure for table candy_exam.peserta
CREATE TABLE IF NOT EXISTS `peserta` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `nama` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
  `nisn` varchar(20) COLLATE utf8mb4_general_ci NOT NULL,
  `tingkat_id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `kelas_id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `jurusan_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `agama_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `username` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `password` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `api_token` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `last_login` datetime DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `nisn` (`nisn`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table candy_exam.peserta: ~0 rows (approximately)

-- Dumping structure for table candy_exam.settings
CREATE TABLE IF NOT EXISTS `settings` (
  `id` int NOT NULL AUTO_INCREMENT,
  `appname` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
  `nama_sekolah` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
  `npsn` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
  `nss` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
  `jenjang` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
  `alamat_sekolah` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
  `website` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
  `email` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
  `kelurahan` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
  `kecamatan` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
  `kota` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
  `provinsi` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
  `nama_kepsek` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
  `nip_kepsek` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
  `tahunpelajaran` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
  `logo` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
  `logokementrian` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
  `favicon` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
  `kop_surat` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
  `key_encrypt` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
  `api_token` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
  `api_url` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
  `kementrian` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
  `appversion` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
  `verifywa_template` text COLLATE utf8mb4_general_ci NOT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table candy_exam.settings: ~0 rows (approximately)
INSERT INTO `settings` (`id`, `appname`, `nama_sekolah`, `npsn`, `nss`, `jenjang`, `alamat_sekolah`, `website`, `email`, `kelurahan`, `kecamatan`, `kota`, `provinsi`, `nama_kepsek`, `nip_kepsek`, `tahunpelajaran`, `logo`, `logokementrian`, `favicon`, `kop_surat`, `key_encrypt`, `api_token`, `api_url`, `kementrian`, `appversion`, `verifywa_template`, `updated_at`) VALUES
	(1, 'Candy CBT', 'SMK Contoh Mandiri', '12345678', '987654321', 'SMK', 'Jl. Pendidikan No.1', 'https://smkcontoh.sch.id', 'admin@smkcontoh.sch.id', 'Kelurahan Contoh', 'Kecamatan Mandiri', 'Kota Edukasi', 'Provinsi Belajar', 'Ibu Guru Hebat', '196512301990032001', '2024/2025', 'logo.png', 'logokem.png', 'favicon.ico', 'kop.png', 'secretkey123456', '123456', 'https://exam.cbtcandy.com', 'Kementerian Pendidikan', '1.0.4', 'Halo {nama}, akun Anda telah diverifikasi untuk ujian.', '2025-09-14 00:33:07');

-- Dumping structure for table candy_exam.settings_exambro
CREATE TABLE IF NOT EXISTS `settings_exambro` (
  `id` int NOT NULL AUTO_INCREMENT,
  `logo_resource` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `banner_img` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `default_brightness` int NOT NULL DEFAULT '95',
  `bell_sound` varchar(255) COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'bell_sound.mp3',
  `exit_sound` varchar(255) COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'exit_sound.mp3',
  `app_volume` int NOT NULL DEFAULT '80',
  `school_name` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
  `app_name` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
  `version` varchar(50) COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'Version 1.0',
  `password_exit` varchar(100) COLLATE utf8mb4_general_ci NOT NULL,
  `secret_code` varchar(100) COLLATE utf8mb4_general_ci NOT NULL,
  `theme_color` varchar(50) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '#2196F3',
  `user_agent` varchar(200) COLLATE utf8mb4_general_ci NOT NULL DEFAULT 'CandyCBTBro',
  `informasi` text COLLATE utf8mb4_general_ci NOT NULL,
  `menu_url` tinyint(1) NOT NULL DEFAULT '1',
  `menu_scanqr` tinyint(1) NOT NULL DEFAULT '1',
  `bluetooth` tinyint(1) NOT NULL DEFAULT '1',
  `mode_exam` tinyint(1) NOT NULL DEFAULT '1',
  `headset` tinyint(1) NOT NULL DEFAULT '1',
  `restrict_user_agent` tinyint(1) NOT NULL DEFAULT '0',
  `portal_ujian` tinyint(1) NOT NULL DEFAULT '0',
  `login_nopassword` tinyint(1) NOT NULL DEFAULT '0',
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table candy_exam.settings_exambro: ~0 rows (approximately)
INSERT INTO `settings_exambro` (`id`, `logo_resource`, `banner_img`, `default_brightness`, `bell_sound`, `exit_sound`, `app_volume`, `school_name`, `app_name`, `version`, `password_exit`, `secret_code`, `theme_color`, `user_agent`, `informasi`, `menu_url`, `menu_scanqr`, `bluetooth`, `mode_exam`, `headset`, `restrict_user_agent`, `portal_ujian`, `login_nopassword`, `updated_at`) VALUES
	(1, 'logo.png', 'banner.jpg', 95, 'bell_sound.mp3', 'exit_sound.mp3', 80, 'SMK Contoh', 'Candy Exam Browser', 'Version 1.0', 'candy123', '$2a$09$gs6X2MIXdFe2VR7IvzlVc.7UyKJ6GNT6RcdazukThmrcAQV50pA9O', '#2196F3', 'CandyCBTBro', 'Selamat datang di Candy Exam!', 1, 1, 1, 1, 1, 0, 0, 0, '2025-09-14 07:33:07');

-- Dumping structure for table candy_exam.soal
CREATE TABLE IF NOT EXISTS `soal` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `topik_soal_id` char(36) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `bank_soal_id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `soal_no` int unsigned DEFAULT NULL,
  `jenis_soal` enum('pg','mpg','jodohkan','benar_salah','esai','isian') COLLATE utf8mb4_general_ci NOT NULL,
  `pertanyaan` longtext COLLATE utf8mb4_general_ci NOT NULL,
  `jawaban` text COLLATE utf8mb4_general_ci,
  `bobot` float NOT NULL DEFAULT '1',
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bank_soal_id` (`bank_soal_id`),
  CONSTRAINT `soal_bank_soal_id_foreign` FOREIGN KEY (`bank_soal_id`) REFERENCES `bank_soal` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table candy_exam.soal: ~0 rows (approximately)

-- Dumping structure for table candy_exam.soal_opsi
CREATE TABLE IF NOT EXISTS `soal_opsi` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `soal_id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `label` varchar(10) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `teks` longtext COLLATE utf8mb4_general_ci,
  `pasangan` text COLLATE utf8mb4_general_ci,
  `is_true` tinyint(1) NOT NULL DEFAULT '0',
  `bobot` float NOT NULL DEFAULT '1',
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `soal_opsi_soal_id_foreign` (`soal_id`),
  CONSTRAINT `soal_opsi_soal_id_foreign` FOREIGN KEY (`soal_id`) REFERENCES `soal` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table candy_exam.soal_opsi: ~0 rows (approximately)

-- Dumping structure for table candy_exam.tingkat
CREATE TABLE IF NOT EXISTS `tingkat` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `nama` varchar(100) COLLATE utf8mb4_general_ci NOT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table candy_exam.tingkat: ~0 rows (approximately)

-- Dumping structure for table candy_exam.topik_soal
CREATE TABLE IF NOT EXISTS `topik_soal` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `bank_soal_id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `nama` varchar(100) COLLATE utf8mb4_general_ci NOT NULL,
  `keterangan` text COLLATE utf8mb4_general_ci,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `topik_soal_bank_soal_id_foreign` (`bank_soal_id`),
  CONSTRAINT `topik_soal_bank_soal_id_foreign` FOREIGN KEY (`bank_soal_id`) REFERENCES `bank_soal` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table candy_exam.topik_soal: ~0 rows (approximately)

-- Dumping structure for table candy_exam.ujian
CREATE TABLE IF NOT EXISTS `ujian` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `bank_soal_id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `nama_ujian` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
  `deskripsi` text COLLATE utf8mb4_general_ci,
  `kode_ujian` varchar(50) COLLATE utf8mb4_general_ci NOT NULL,
  `token` varchar(50) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `acak_soal` tinyint(1) NOT NULL DEFAULT '0',
  `acak_opsi` tinyint(1) NOT NULL DEFAULT '0',
  `pakai_token` tinyint(1) NOT NULL DEFAULT '0',
  `durasi_ujian` int DEFAULT NULL,
  `minimal_durasi` int DEFAULT NULL,
  `tampil_nilai` tinyint(1) NOT NULL DEFAULT '1',
  `tampil_pembahasan` tinyint(1) NOT NULL DEFAULT '0',
  `pakai_webcam` tinyint(1) NOT NULL DEFAULT '0',
  `perangkat_terkunci` tinyint(1) NOT NULL DEFAULT '1',
  `single_login` tinyint(1) NOT NULL DEFAULT '0',
  `created_by` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `waktu_mulai` datetime NOT NULL,
  `waktu_selesai` datetime NOT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `dibagikan` tinyint(1) NOT NULL DEFAULT '0',
  `butuh_login` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ujian_bank_soal_id_foreign` (`bank_soal_id`),
  CONSTRAINT `ujian_bank_soal_id_foreign` FOREIGN KEY (`bank_soal_id`) REFERENCES `bank_soal` (`id`) ON DELETE CASCADE ON UPDATE RESTRICT
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table candy_exam.ujian: ~0 rows (approximately)

-- Dumping structure for table candy_exam.users
CREATE TABLE IF NOT EXISTS `users` (
  `id` char(36) COLLATE utf8mb4_general_ci NOT NULL,
  `username` varchar(50) COLLATE utf8mb4_general_ci NOT NULL,
  `email` varchar(100) COLLATE utf8mb4_general_ci NOT NULL,
  `full_name` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `password` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
  `roles` text COLLATE utf8mb4_general_ci,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `remember_token` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `deleted_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `username` (`username`),
  UNIQUE KEY `email` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Dumping data for table candy_exam.users: ~2 rows (approximately)
INSERT INTO `users` (`id`, `username`, `email`, `full_name`, `password`, `roles`, `is_active`, `remember_token`, `created_at`, `updated_at`, `deleted_at`) VALUES
	('0dd47310-7d7f-40f3-96d3-181294472187', 'nurrahmansyah', 'smppgri1cbg@gmail.com', 'nurrahmansyah', '$2y$10$77zmRocqoC1d11Kg.sg.C.oj9a9qZopgbZzCnrVzAgxdInYloBnsm', 'guru', 1, NULL, '2025-09-12 07:09:48', '2025-09-12 07:09:48', NULL),
	('3af53bb8-5950-43ff-a289-6355f749562d', 'admin', 'admin@smkcontoh.sch.id', 'admin', '$2y$10$HuIl.WpziA2w9U2ZDd0U0Oy3crxGIdjpWn.iiGkJ/rP2SNmy7mxdW', 'admin', 1, NULL, '2025-09-14 07:33:08', NULL, NULL);

/*!40103 SET TIME_ZONE=IFNULL(@OLD_TIME_ZONE, 'system') */;
/*!40101 SET SQL_MODE=IFNULL(@OLD_SQL_MODE, '') */;
/*!40014 SET FOREIGN_KEY_CHECKS=IFNULL(@OLD_FOREIGN_KEY_CHECKS, 1) */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40111 SET SQL_NOTES=IFNULL(@OLD_SQL_NOTES, 1) */;
