<?php $this->extend('Layout/main'); ?>
<?php $this->section('content'); ?>
<style>
    /* Custom minimalis toggle */
    .custom-switch .form-check-input {
        width: 2.5em;
        height: 1.3em;
        cursor: pointer;
        border-radius: 1.5em;
        background-color: #ddd;
        border: none;
        transition: all 0.3s ease;
        position: relative;
    }

    .custom-switch .form-check-input:checked {
        background-color: #0d6efd;
        box-shadow: 0 0 6px rgba(13, 110, 253, 0.6);
    }

    .custom-switch .form-check-input::before {
        content: "";
        position: absolute;
        top: 0.15em;
        left: 0.2em;
        width: 0.9em;
        height: 0.9em;
        background: #fff;
        border-radius: 50%;
        transition: all 0.3s ease;
    }

    .custom-switch .form-check-input:checked::before {
        transform: translateX(1.2em);
    }


    /* Efek hover kode ujian */
    #copyKodeWrapper:hover {
        background: #e9f3ff;
        transform: scale(1.03);
        box-shadow: 0 0 12px rgba(0, 123, 255, 0.4);
        transition: all 0.3s ease;
    }

    /* Efek QR Code */
    #qrCode img {
        transition: transform 0.4s ease, box-shadow 0.4s ease;
    }

    #qrCode img:hover {
        transform: scale(1.1);
        box-shadow: 0 0 20px rgba(0, 123, 255, 0.5);
    }

    /* Efek input group link */
    .input-group:hover {
        transform: translateY(-3px);
        transition: transform 0.3s ease;
    }

    /* Tombol salin link */
    #copyLink:hover {
        background-color: #0d6efd;
        color: white;
        transform: scale(1.05);
        transition: all 0.3s ease;
    }

    /* Tombol masuk */
    #masukLink {
        transition: all 0.3s ease;
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
    }

    #masukLink:hover {
        transform: scale(1.05);
        box-shadow: 0 0 18px rgba(0, 123, 255, 0.6);
    }
</style>

<style>
    .jadwal-badge {
        border-radius: 0.375rem;
        padding: 0.25rem 0.5rem;
        display: flex;
        align-items: center;
        gap: 0.25rem;
        transition: all 0.2s ease;
        cursor: default;
    }

    .jadwal-badge:hover {
        background-color: rgba(0, 123, 255, 0.1);
        /* highlight biru lembut */
        transform: translateY(-2px);
        box-shadow: 0 2px 6px rgba(0, 0, 0, 0.1);
    }

    .aksi-icons a {
        display: inline-flex;
        align-items: center;
        justify-content: center;
        padding: 0.25rem;
        border-radius: 0.375rem;
        transition: all 0.2s ease;
    }

    .aksi-icons a:hover {
        transform: scale(1.2);
        filter: brightness(1.2);
        box-shadow: 0 2px 6px rgba(0, 0, 0, 0.15);
    }

    /* Card interaktif dengan glow biru */
    .card.interactive-card {
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        cursor: pointer;
        position: relative;
    }

    .card.interactive-card:hover {
        transform: translateY(-5px) scale(1.02);
        box-shadow: 0 12px 24px rgba(0, 123, 255, 0.4), 0 0 12px rgba(0, 123, 255, 0.3);
    }

    .card.interactive-card:active {
        transform: translateY(-2px) scale(1.01);
        box-shadow: 0 8px 16px rgba(0, 123, 255, 0.2), 0 0 8px rgba(0, 123, 255, 0.2);
    }
</style>
<div class="layout-px-spacing">
    <div class="middle-content container-xxl p-0">
        <div class="layout-top-spacing">
            <div class="d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center mb-3 gap-2">
                <h5 class="fw-semibold mb-0">Manajemen Ujian</h5>
                <div class="d-flex gap-2">
                    <button type="button" onclick="add()" class="btn btn-primary">
                        <i data-feather="plus-circle"></i> Tambah
                    </button>
                    <button type="button" id="refreshList" class="btn btn-outline-secondary">
                        <i data-feather="refresh-cw"></i>
                    </button>
                </div>
            </div>

            <!-- Search -->
            <div class="mb-3">
                <input type="text" id="searchBox" class="form-control" placeholder="Cari ujian...">
            </div>

            <!-- Tempat render list ujian -->
            <div id="ujianList" class="d-flex flex-column gap-3"></div>

            <!-- Pagination -->
            <nav>
                <ul id="pagination" class="pagination justify-content-center mt-3"></ul>
            </nav>

        </div>
    </div>
</div>

<div class="modal fade" id="tambahPesertaModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <form id="formTambahPeserta" class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Tambah Peserta</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                    <i data-feather="x"></i>
                </button>
            </div>
            <div class="modal-body">
                <input type="hidden" name="ujian_id">

                <div class="row g-3">
                    <div class="col-md-3">
                        <label for="filter_tingkat" class="form-label">Tingkat</label>
                        <select id="filter_tingkat" class="form-control form-control-sm">
                            <option value="">Semua</option>
                            <?php foreach ($tingkat as $t): ?>
                                <option value="<?= esc($t['id']) ?>"><?= esc($t['nama']) ?></option>
                            <?php endforeach; ?>
                        </select>

                    </div>
                    <div class="col-md-3">
                        <label for="filter_kelas" class="form-label">Kelas</label>
                        <select id="filter_kelas" class="form-control form-control-sm">
                            <option value="">Semua</option>
                            <?php foreach ($kelas as $k): ?>
                                <option value="<?= esc($k['id']) ?>"><?= esc($k['nama']) ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label for="filter_jurusan" class="form-label">Jurusan</label>
                        <select id="filter_jurusan" class="form-control form-control-sm">
                            <option value="">Semua</option>
                            <?php foreach ($jurusan as $j): ?>
                                <option value="<?= esc($j['id']) ?>"><?= esc($j['nama']) ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label for="filter_agama" class="form-label">Agama</label>
                        <select id="filter_agama" class="form-control form-control-sm">
                            <option value="">Semua</option>
                            <?php foreach ($agama as $a): ?>
                                <option value="<?= esc($a['id']) ?>"><?= esc($a['nama']) ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div>

                <div class="row mt-3">
                    <div class="col-md-5">
                        <label>Belum Ditambahkan (<span id="count-belum">0</span>)</label>
                        <select id="list-belum" class="form-select" multiple size="10">
                            <!-- Diisi via AJAX -->
                        </select>
                    </div>
                    <div class="col-md-2 d-flex flex-column justify-content-center align-items-center gap-2">
                        <button type="button" class="btn btn-outline-primary btn-sm" id="btn-tambah">
                            <i data-feather="arrow-right-circle"></i>
                        </button>
                        <button type="button" class="btn btn-outline-danger btn-sm" id="btn-hapus">
                            <i data-feather="arrow-left-circle"></i>
                        </button>
                    </div>
                    <div class="col-md-5">
                        <label>Sudah Ditambahkan (<span id="count-sudah">0</span>)</label>
                        <select name="peserta_id[]" id="list-sudah" class="form-select" multiple size="10">
                            <!-- Akan dipindahkan dari kiri ke kanan -->
                        </select>
                    </div>
                </div>

            </div>
            <div class="modal-footer">
                <button type="submit" class="btn btn-primary">Simpan</button>
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
            </div>
        </form>
    </div>
</div>


<div class="modal fade" id="modal_form" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <form id="form" class="modal-content needs-validation" novalidate>
            <div class="modal-header">
                <h5 class="modal-title">Form Ujian</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                    <i data-feather="x"></i>
                </button>
            </div>
            <div class="modal-body">
                <div id="errorMessages"></div>
                <input type="hidden" name="id">
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label>Nama Ujian</label>
                        <input type="text" name="nama_ujian" class="form-control form-control-sm" required>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label>Kode Ujian</label>
                        <div class="input-group input-group-sm">
                            <input type="text" name="kode_ujian" id="kodeUjian"
                                class="form-control" required readonly>
                            <button type="button" class="btn btn-outline-primary" id="btnGenerateKode">
                                <i data-feather="refresh-ccw"></i> Generate
                            </button>
                        </div>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label>Token</label>
                        <input type="text" name="token" class="form-control form-control-sm">
                    </div>
                    <div class="col-md-6 form-group mb-3">
                        <label>Bank Soal</label>
                        <select name="bank_soal_id" class="form-control form-control-sm">
                            <?php foreach ($banks as $b): ?>
                                <option value="<?= $b['id'] ?>"><?= esc($b['nama']) ?></option>
                            <?php endforeach ?>
                        </select>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label>Durasi Ujian (menit)</label>
                        <input type="number" name="durasi_ujian" class="form-control form-control-sm">
                    </div>
                    <div class="col-md-6 mb-3">
                        <label>Minimal Durasi (menit)</label>
                        <input type="number" name="minimal_durasi" class="form-control form-control-sm">
                    </div>
                    <div class="col-md-6 mb-3">
                        <label>Mulai</label>
                        <input type="datetime-local" name="waktu_mulai" class="form-control form-control-sm" required>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label>Selesai</label>
                        <input type="datetime-local" name="waktu_selesai" class="form-control form-control-sm" required>
                    </div>
                    <div class="form-group mb-3">
                        <label>Dibuat Oleh</label>
                        <select name="created_by" class="form-control form-control-sm">
                            <?php foreach ($gurus as $g): ?>
                                <option value="<?= $g['id'] ?>"><?= esc($g['full_name']) ?></option>
                            <?php endforeach ?>
                        </select>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label>Pengaturan</label>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="acak_soal" value="1" id="acak_soal">
                            <label class="form-check-label" for="acak_soal">Acak Soal</label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="acak_opsi" value="1" id="acak_opsi">
                            <label class="form-check-label" for="acak_opsi">Acak Opsi</label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="pakai_token" value="1" id="pakai_token">
                            <label class="form-check-label" for="pakai_token">Pakai Token</label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="tampil_nilai" value="1" id="tampil_nilai">
                            <label class="form-check-label" for="tampil_nilai">Tampilkan Nilai</label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="tampil_pembahasan" value="1" id="tampil_pembahasan">
                            <label class="form-check-label" for="tampil_pembahasan">Tampilkan Pembahasan</label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="pakai_webcam" value="1" id="pakai_webcam">
                            <label class="form-check-label" for="pakai_webcam">Pakai Webcam</label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="single_login" value="1" id="single_login">
                            <label class="form-check-label" for="single_login">Single Login Device</label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="perangkat_terkunci" value="1" id="perangkat_terkunci">
                            <label class="form-check-label" for="perangkat_terkunci">Perangkat Terkunci</label>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-light-dark" data-bs-dismiss="modal">Batal</button>
                <button type="button" onclick="save()" class="btn btn-primary">Simpan</button>
            </div>
        </form>
    </div>
</div>
<div class="modal fade" id="shareModal" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content border-0 shadow-lg rounded-3">
            <div class="modal-header">
                <h5 class="modal-title" id="ujianNama"></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                    <i data-feather="x"></i>
                </button>
            </div>
            <div class="modal-body text-center">
                <!-- Nama Ujian
                <h6 id="ujianNama" class="fw-bold mb-3"></h6> -->

                <!-- Kode Ujian -->
                <div class="bg-light rounded p-2 mb-3 position-relative" style="cursor: pointer;" id="copyKodeWrapper">
                    <small class="text-muted">Kode Masuk</small>
                    <div id="ujianKode" class="fs-3 fw-bold text-primary">123456</div>
                    <small id="copyNotif" class="text-success position-absolute top-0 end-0 m-2" style="display:none;">✅ Disalin</small>
                </div>

                <!-- QR Code -->
                <div id="qrCode" class="d-flex justify-content-center mb-3"></div>

                <!-- Link & Salin -->
                <div class="input-group mb-3">
                    <input type="text" id="ujianLink" class="form-control" readonly>
                    <button class="btn btn-outline-primary" id="copyLink">Salin</button>
                </div>

                <!-- Opsi Login -->
                <div class="mb-3 text-start">
                    <label class="form-label d-block mb-1 fw-semibold">Opsi Login</label>
                    <div class="d-flex align-items-center gap-2">
                        <div class="form-check form-switch custom-switch">
                            <input class="form-check-input" type="checkbox" id="butuh_login">
                        </div>
                        <span id="opsiLoginLabel" class="small text-muted">Peserta tidak perlu login</span>
                    </div>
                </div>

                <!-- Opsi Dibagikan -->
                <div class="mb-3 text-start">
                    <label class="form-label d-block mb-1 fw-semibold">Status Ujian</label>
                    <div class="d-flex align-items-center gap-2">
                        <div class="form-check form-switch custom-switch">
                            <input class="form-check-input" type="checkbox" id="dibagikan">
                        </div>
                        <span id="opsiBagikanLabel" class="small text-muted">Belum dibagikan</span>
                    </div>
                </div>

                <!-- Tombol Masuk -->
                <a href="#" id="masukLink" class="btn btn-primary w-100">Masuk</a>
            </div>
        </div>
    </div>
</div>


<?php $this->endSection(); ?>
<?php $this->section('pagejs'); ?>
<script src="<?= base_url() ?>src/plugins/src/editors/quill/qrcode.min.js"></script>
<script>
    $(document).ready(function() {
        const $shareModal = $("#shareModal");
        const $butuhLogin = $("#butuh_login");
        const $dibagikan = $("#dibagikan");
        const $opsiLoginLabel = $("#opsiLoginLabel");
        const $opsiBagikanLabel = $("#opsiBagikanLabel");

        // --- SIMPAN OPSI ---
        function saveOption(type, value) {
            let ujianId = $shareModal.data("id"); // ambil dari data-id modal
            $.ajax({
                url: "<?= base_url('panel/ujian/update-share') ?>/" + ujianId,
                type: "POST",
                data: {
                    option: type,
                    value: value ? 1 : 0,
                    "<?= csrf_token() ?>": "<?= csrf_hash() ?>"
                },
                success: function(res) {
                    if (!res.status) {
                        alert("❌ Gagal menyimpan opsi!");
                    }
                },
                error: function() {
                    alert("⚠️ Terjadi kesalahan koneksi!");
                }
            });
        }

        // --- TOGGLE butuh_login ---
        $butuhLogin.on("change", function() {
            let checked = $(this).is(":checked");
            $opsiLoginLabel.text(checked ? "Peserta harus login" : "Peserta tidak perlu login");
            saveOption("butuh_login", checked);
        });

        // --- TOGGLE dibagikan ---
        $dibagikan.on("change", function() {
            let checked = $(this).is(":checked");
            $opsiBagikanLabel.text(checked ? "Sudah dibagikan" : "Belum dibagikan");
            saveOption("dibagikan", checked);
        });

        // --- SHARE BUTTON CLICK ---
        $(document).on("click", ".share-btn", function() {
            const nama = $(this).data("nama");
            const kode = $(this).data("kode");
            const link = $(this).data("link");
            const id = $(this).data("id");

            // Set konten awal modal
            $shareModal.data("id", id);
            $("#ujianNama").text(nama);
            $("#ujianKode").text(kode);
            $("#ujianLink").val(link);
            $("#masukLink").attr("href", link);

            // Generate QR baru
            $("#qrCode").html("");
            new QRCode(document.getElementById("qrCode"), {
                text: link,
                width: 150,
                height: 150
            });

            // 🔥 Ambil data dari list yang sama dengan edit-btn
            $.get("<?= base_url('panel/ujian/list') ?>", function(res) {
                const item = res.data.find(i => i.id == id);
                if (item) {
                    // Set opsi sesuai database
                    $butuhLogin.prop("checked", item.butuh_login == "1");
                    $opsiLoginLabel.text(
                        item.butuh_login == "1" ? "Peserta harus login" : "Peserta tidak perlu login"
                    );

                    $dibagikan.prop("checked", item.dibagikan == "1");
                    $opsiBagikanLabel.text(
                        item.dibagikan == "1" ? "Sudah dibagikan" : "Belum dibagikan"
                    );
                }
            });

            // Tampilkan modal
            $shareModal.modal("show");
        });


        // --- SALIN LINK ---
        $("#copyLink").on("click", function() {
            const linkInput = $("#ujianLink")[0];
            const btn = $(this);

            if (navigator.clipboard && navigator.clipboard.writeText) {
                navigator.clipboard.writeText(linkInput.value).then(() => {
                    btn.text("✅ Disalin");
                    setTimeout(() => btn.text("Salin"), 2000);
                }).catch(() => fallbackCopy(linkInput, btn));
            } else {
                fallbackCopy(linkInput, btn);
            }

            function fallbackCopy(input, button) {
                input.select();
                input.setSelectionRange(0, 99999); // untuk mobile
                try {
                    const success = document.execCommand("copy");
                    if (success) {
                        button.text("✅ Disalin");
                        setTimeout(() => button.text("Salin"), 2000);
                    } else {
                        alert("Gagal menyalin. Silakan salin manual.");
                    }
                } catch (err) {
                    alert("Gagal menyalin. Silakan salin manual.");
                }
            }
        });

        // --- SALIN KODE ---
        $("#copyKodeWrapper").on("click", function() {
            const kode = $("#ujianKode").text().trim();
            const copyNotif = $("#copyNotif");
            navigator.clipboard.writeText(kode).then(() => {
                copyNotif.show();
                setTimeout(() => copyNotif.hide(), 1500);
            });
        });
    });
</script>


<script>
    const base_url = '<?= base_url() ?>';
    let save_method = 'add';
    let allData = [];
    let currentPage = 1;
    const perPage = 5;

    $(document).ready(function() {
        loadData();

        $('#refreshList').on('click', function() {
            loadData();
        });

        $('#searchBox').on('input', function() {
            currentPage = 1;
            renderList();
        });
    });

    function loadData() {
        $.getJSON(`${base_url}panel/ujian/list`, function(res) {
            allData = res.data || [];
            currentPage = 1;
            renderList();
        });
    }

    function renderList() {
        let search = $('#searchBox').val().toLowerCase();
        let filtered = allData.filter(item =>
            item.nama_ujian.toLowerCase().includes(search) ||
            item.nama_bank_soal.toLowerCase().includes(search)
        );

        let start = (currentPage - 1) * perPage;
        let paginated = filtered.slice(start, start + perPage);

        let html = '';
        if (paginated.length === 0) {
            html = `<div class="alert alert-light text-center">Tidak ada data ujian</div>`;
        } else {
            paginated.forEach(row => {
                let collapseId = `collapseUjian${row.id}`;

                html += `
      <div class="card interactive-card shadow-sm border-0 rounded-3 p-3 mb-2">
        <div class="d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center">
          <div>
            <h5 class="mb-1 fw-semibold">${row.nama_ujian}</h5>
            <p class="mb-1 text-muted small">
              Bank Soal: <span class="fw-medium">${row.nama_bank_soal}</span>
            </p>
            
           <!-- Status & Waktu (clean minimalis dengan animasi hover) -->
            <div class="d-flex flex-wrap gap-3 mb-2 text-muted small align-items-center">
            <span class="jadwal-badge ${row.is_active == 1 ? 'text-success fw-semibold' : 'text-secondary'}">
                <i data-feather="circle"></i> ${row.is_active == 1 ? 'Aktif' : 'Nonaktif'}
            </span>

            <span class="jadwal-badge">
                <i data-feather="clock"></i> ${row.durasi_ujian ?? 0} menit
            </span>

            <span class="jadwal-badge text-muted small">
                <i data-feather="calendar" class="me-1"></i>
                ${formatDateClean(row.waktu_mulai)} – ${formatDateClean(row.waktu_selesai)}
            </span>

            <span class="jadwal-badge text-muted small">
                <i data-feather="user" class="me-1"></i> ${row.jumlah_peserta ?? 0} Peserta
            </span>
            </div>



          <!-- Link collapse detail opsi -->
            <a class="text-muted small fw-medium d-inline-flex align-items-center gap-1 toggle-opsi" 
                data-bs-toggle="collapse" 
                href="#${collapseId}" 
                role="button" 
                aria-expanded="false">
                <span>Opsi lainnya</span>
                <i data-feather="chevron-down" class="icon-toggle"></i>
            </a>

                </div>
                
                
           <!-- Card body ... -->
            <div class="d-flex flex-column justify-content-between">

            <!-- Konten utama card -->
            <div>
                <!-- Judul, bank soal, status, dll -->
            </div>

            <!-- Aksi minimalis di bawah -->
            <div class="aksi-icons d-flex align-items-center gap-2 mt-3 justify-content-end">
                <!-- Tambah Peserta -->
                <a href="javascript:void(0)" class="text-success tambah-peserta-btn" 
                    data-id="${row.id}" data-bs-toggle="modal" data-bs-target="#tambahPesertaModal"
                    title="Tambah Peserta">
                    <i data-feather="user-plus"></i>
                </a>

                <!-- Edit -->
                <a href="javascript:void(0)" class="text-primary edit-btn" data-id="${row.id}" title="Edit">
                    <i data-feather="edit"></i>
                </a>

                <!-- Hapus -->
                <a href="javascript:void(0)" class="text-danger delete-btn" data-id="${row.id}" title="Hapus">
                    <i data-feather="trash-2"></i>
                </a>

                <!-- Detail -->
                <a href="${base_url}panel/ujian/detail/${row.id}" class="text-secondary" title="Detail">
                    <i data-feather="info"></i>
                </a>
                <!-- Bagikan -->
                <a href="javascript:void(0)" 
                    class="text-warning share-btn" 
                    data-id="${row.id}" 
                    data-nama="${row.nama_ujian}" 
                    data-kode="${row.kode_ujian}" 
                    data-link="${base_url}share/ujian/play/${row.token}" 
                    title="Bagikan">
                    <i data-feather="share-2"></i>
                </a>

            </div>

            </div>



        </div>

        <!-- Collapse Detail Opsi (ikon minimalis aktif = warna, nonaktif = abu2) -->
            <div class="collapse mt-3" id="${collapseId}">
            <div class="d-flex flex-wrap gap-2">

                ${row.single_login == '1' 
                ? `<span class="badge rounded-pill bg-success px-3 py-2 d-flex align-items-center gap-1" title="Single Login">
                    <i data-feather="log-in"></i> <small>Aktif</small>
                </span>`
                : `<span class="badge rounded-pill bg-secondary px-3 py-2 d-flex align-items-center gap-1" title="Single Login">
                    <i data-feather="log-in"></i> <small>Nonaktif</small>
                </span>`}

                ${row.pakai_token == '1' 
                ? `<span class="badge rounded-pill bg-success px-3 py-2 d-flex align-items-center gap-1" title="Pakai Token">
                    <i data-feather="key"></i> <small>Aktif (${row.token})</small>
                </span>`
                : `<span class="badge rounded-pill bg-secondary px-3 py-2 d-flex align-items-center gap-1" title="Pakai Token">
                    <i data-feather="key"></i> <small>Nonaktif</small>
                </span>`}

                ${row.acak_soal == '1' 
                ? `<span class="badge rounded-pill bg-success px-3 py-2 d-flex align-items-center gap-1" title="Acak Soal">
                    <i data-feather="shuffle"></i> <small>Aktif</small>
                </span>`
                : `<span class="badge rounded-pill bg-secondary px-3 py-2 d-flex align-items-center gap-1" title="Acak Soal">
                    <i data-feather="shuffle"></i> <small>Nonaktif</small>
                </span>`}

                ${row.acak_opsi == '1' 
                ? `<span class="badge rounded-pill bg-success px-3 py-2 d-flex align-items-center gap-1" title="Acak Opsi">
                    <i data-feather="repeat"></i> <small>Aktif</small>
                </span>`
                : `<span class="badge rounded-pill bg-secondary px-3 py-2 d-flex align-items-center gap-1" title="Acak Opsi">
                    <i data-feather="repeat"></i> <small>Nonaktif</small>
                </span>`}

                ${row.tampil_nilai == '1' 
                ? `<span class="badge rounded-pill bg-success px-3 py-2 d-flex align-items-center gap-1" title="Tampilkan Nilai">
                    <i data-feather="bar-chart-2"></i> <small>Aktif</small>
                </span>`
                : `<span class="badge rounded-pill bg-secondary px-3 py-2 d-flex align-items-center gap-1" title="Tampilkan Nilai">
                    <i data-feather="bar-chart-2"></i> <small>Nonaktif</small>
                </span>`}

                ${row.tampil_pembahasan == '1' 
                ? `<span class="badge rounded-pill bg-success px-3 py-2 d-flex align-items-center gap-1" title="Tampilkan Pembahasan">
                    <i data-feather="book-open"></i> <small>Aktif</small>
                </span>`
                : `<span class="badge rounded-pill bg-secondary px-3 py-2 d-flex align-items-center gap-1" title="Tampilkan Pembahasan">
                    <i data-feather="book-open"></i> <small>Nonaktif</small>
                </span>`}

                ${row.pakai_webcam == '1' 
                ? `<span class="badge rounded-pill bg-success px-3 py-2 d-flex align-items-center gap-1" title="Pakai Webcam">
                    <i data-feather="video"></i> <small>Aktif</small>
                </span>`
                : `<span class="badge rounded-pill bg-secondary px-3 py-2 d-flex align-items-center gap-1" title="Pakai Webcam">
                    <i data-feather="video"></i> <small>Nonaktif</small>
                </span>`}

                ${row.perangkat_terkunci == '1' 
                ? `<span class="badge rounded-pill bg-success px-3 py-2 d-flex align-items-center gap-1" title="Perangkat Terkunci">
                    <i data-feather="lock"></i> <small>Aktif</small>
                </span>`
                : `<span class="badge rounded-pill bg-secondary px-3 py-2 d-flex align-items-center gap-1" title="Perangkat Terkunci">
                    <i data-feather="lock"></i> <small>Nonaktif</small>
                </span>`}

            </div>
            </div>

      </div>`;
            });
        }

        $('#ujianList').html(html);
        feather.replace();
        renderPagination(filtered.length);
    }

    function formatDateClean(dateStr) {
        if (!dateStr) return '-';
        const date = new Date(dateStr);

        const day = String(date.getDate()).padStart(2, '0');
        const month = date.toLocaleString('id-ID', {
            month: 'short'
        });
        const year = date.getFullYear();
        const hours = String(date.getHours()).padStart(2, '0');
        const mins = String(date.getMinutes()).padStart(2, '0');

        return `${day} ${month} ${year}, ${hours}:${mins}`;
    }



    function renderPagination(total) {
        let totalPages = Math.ceil(total / perPage);
        let html = '';

        if (totalPages > 1) {
            for (let i = 1; i <= totalPages; i++) {
                html += `
          <li class="page-item ${i === currentPage ? 'active' : ''}">
            <a class="page-link" href="javascript:void(0)" onclick="gotoPage(${i})">${i}</a>
          </li>`;
            }
        }

        $('#pagination').html(html);
    }

    function gotoPage(page) {
        currentPage = page;
        renderList();
    }
    // TOMBOL EDIT
    $(document).on('click', '.edit-btn', function() {
        const id = $(this).data('id');

        $.get('<?= base_url('panel/ujian/list') ?>', function(res) {
            const item = res.data.find(i => i.id == id);
            if (item) {
                $('[name="id"]').val(item.id);
                $('[name="bank_soal_id"]').val(item.bank_soal_id);
                $('[name="nama_ujian"]').val(item.nama_ujian);
                $('[name="deskripsi"]').val(item.deskripsi);
                $('[name="kode_ujian"]').val(item.kode_ujian);
                $('[name="token"]').val(item.token);
                $('[name="durasi_ujian"]').val(item.durasi_ujian);
                $('[name="minimal_durasi"]').val(item.minimal_durasi);
                $('[name="waktu_mulai"]').val(item.waktu_mulai);
                $('[name="waktu_selesai"]').val(item.waktu_selesai);

                $('[name="acak_soal"]').prop('checked', item.acak_soal == '1');
                $('[name="acak_opsi"]').prop('checked', item.acak_opsi == '1');
                $('[name="pakai_token"]').prop('checked', item.pakai_token == '1');
                $('[name="tampil_nilai"]').prop('checked', item.tampil_nilai == '1');
                $('[name="tampil_pembahasan"]').prop('checked', item.tampil_pembahasan == '1');
                $('[name="pakai_webcam"]').prop('checked', item.pakai_webcam == '1');
                $('[name="perangkat_terkunci"]').prop('checked', item.perangkat_terkunci == '1');
                $('[name="single_login"]').prop('checked', item.single_login == '1');

                $('[name="created_by"]').val(item.created_by);

                $('.modal-title').text('Edit Ujian');
                $('#modal_form').modal('show');
                save_method = 'edit';
            }
        });
    });

    // TOMBOL DELETE
    $(document).on('click', '.delete-btn', function() {
        const id = $(this).data('id');

        Swal.fire({
            title: 'Yakin hapus ujian ini?',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Ya',
            cancelButtonText: 'Tidak'
        }).then(result => {
            if (result.isConfirmed) {
                $.post(`<?= base_url('panel/ujian/delete/') ?>${id}`, function(res) {
                    if (res.status) {
                        loadData(); // refresh list card
                        Snackbar.show({
                            text: res.message,
                            pos: 'top-center'
                        });
                    } else {
                        Snackbar.show({
                            text: res.message,
                            pos: 'top-center'
                        });
                    }
                }, 'json');
            }
        });
    });

    // TOMBOL TAMBAH PESERTA
    // $(document).on('click', '.tambah-peserta-btn', function() {
    //     const ujianId = $(this).data('id');
    //     $('#tambahPesertaModal [name="ujian_id"]').val(ujianId);
    //     $('#tambahPesertaModal').modal('show');
    // });

    function add() {
        save_method = 'add';
        $('#form')[0].reset();
        $('[name="token"]').val(generateToken());
        $('[name="kode_ujian"]').val(generateKodeUjian());
        $('.modal-title').text('Tambah Ujian');
        $('#modal_form').modal('show');
    }
    const btnGenerate = document.getElementById('btnGenerateKode');
    // klik tombol generate
    btnGenerate.addEventListener('click', function() {
        $('[name="kode_ujian"]').val(generateKodeUjian());
    });

    function generateKodeUjian(length = 6) {
        let code = '';
        for (let i = 0; i < length; i++) {
            code += Math.floor(Math.random() * 10); // angka 0-9
        }
        return code;
    }

    function generateToken(length = 6) {
        const chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
        return Array.from({
            length
        }, () => chars[Math.floor(Math.random() * chars.length)]).join('');
    }


    function save() {
        const url = save_method === 'add' ?
            '<?= base_url('panel/ujian/create') ?>' :
            '<?= base_url('panel/ujian/update') ?>/' + $('[name="id"]').val();

        if ($('#form')[0].checkValidity() === false) {
            $('#form').addClass('was-validated');
            return;
        }

        let formData = $('#form').serializeArray();

        const checkboxNames = [
            'acak_soal',
            'acak_opsi',
            'pakai_token',
            'tampil_nilai',
            'tampil_pembahasan',
            'pakai_webcam',
            'perangkat_terkunci',
            'single_login'
        ];

        checkboxNames.forEach(name => {
            formData = formData.filter(f => f.name !== name);
            formData.push({
                name: name,
                value: $(`[name="${name}"]`).is(':checked') ? '1' : '0'
            });
        });

        $.post(url, $.param(formData), function(res) {
            if (res.status) {
                $('#modal_form').modal('hide');

                // Refresh ulang data & render list
                loadData();

                Snackbar.show({
                    text: res.message,
                    pos: 'top-center'
                });
            } else {
                let errors = '<div class="alert alert-danger"><ul>';
                $.each(res.message, (k, v) => {
                    errors += `<li>${v}</li>`;
                });
                errors += '</ul></div>';
                $('#errorMessages').html(errors);
            }
        }, 'json');
    }
</script>


<script>
    $(document).ready(function() {
        // Trigger awal dan saat filter berubah
        $('#filter_tingkat, #filter_kelas, #filter_jurusan, #filter_agama').on('change', loadPesertaBelumDitambahkan);

        // Saat modal dibuka, inisialisasi ID ujian dan load peserta
        $('#tambahPesertaModal').on('show.bs.modal', function(e) {
            const ujianId = $(e.relatedTarget).data('id');
            $('[name="ujian_id"]').val(ujianId);
            loadPesertaBelumDitambahkan();
            loadPesertaSudahDitambahkan(ujianId);
        });

        $('#btn-tambah').click(function() {
            $('#list-belum option:selected').each(function() {
                const cloned = $(this).clone().prop('selected', true); // ✅ auto selected
                $('#list-sudah').append(cloned);
                $(this).remove();
            });
            updateCounts(); // ✅ di sini
        });


        $('#btn-hapus').click(function() {
            const selected = $('#list-sudah option:selected');
            const ujianId = $('[name="ujian_id"]').val();

            if (selected.length === 0) return;

            const pesertaIds = [];
            selected.each(function() {
                pesertaIds.push($(this).val());
            });

            // Kirim ke server untuk cek apakah peserta-peserta itu sudah tercatat di hasil_ujian
            $.post('<?= base_url('panel/ujian/cek-peserta-diuji') ?>', {
                ujian_id: ujianId,
                peserta_id: pesertaIds
            }, function(res) {
                if (!res.status) {
                    Snackbar.show({
                        text: res.message,
                        pos: 'top-center'
                    });
                    return;
                }

                const {
                    sudahAda,
                    belumAda
                } = res.data;

                // Kalau belum ada, langsung pindah
                belumAda.forEach(id => {
                    const opt = $('#list-sudah option[value="' + id + '"]');
                    $('#list-belum').append(opt.clone());
                    opt.remove();
                    updateCounts(); // ✅ Update jumlah
                });

                // Kalau sudah ada, konfirmasi dulu
                if (sudahAda.length > 0) {
                    if (confirm('Beberapa peserta sudah memiliki data hasil ujian. Menghapus mereka akan menghapus seluruh nilai. Lanjutkan?')) {
                        $.post('<?= base_url('panel/ujian/remove-peserta') ?>', {
                            ujian_id: ujianId,
                            peserta_id: sudahAda
                        }, function(resRemove) {
                            if (resRemove.status) {
                                sudahAda.forEach(id => {
                                    const opt = $('#list-sudah option[value="' + id + '"]');
                                    $('#list-belum').append(opt.clone());
                                    opt.remove();
                                    updateCounts(); // ✅ Update jumlah
                                });
                                Snackbar.show({
                                    text: resRemove.message,
                                    pos: 'top-center'
                                });
                            } else {
                                Snackbar.show({
                                    text: resRemove.message,
                                    pos: 'top-center'
                                });
                            }
                        }, 'json');
                    }
                }
            }, 'json');
        });


        // Submit form peserta ujian
        $('#formTambahPeserta').on('submit', function(e) {
            e.preventDefault();
            const formData = $(this).serialize();

            $.post('<?= base_url('panel/ujian/add-peserta') ?>', formData, function(res) {
                if (res.status) {
                    $('#tambahPesertaModal').modal('hide');
                    loadData();
                    Snackbar.show({
                        text: res.message,
                        pos: 'top-center'
                    });
                } else {
                    Snackbar.show({
                        text: 'Gagal menyimpan data peserta.',
                        pos: 'top-center'
                    });
                }
            }, 'json');
        });
    });

    function loadPesertaBelumDitambahkan() {
        const ujianId = $('[name="ujian_id"]').val();
        const data = {
            tingkat_id: $('#filter_tingkat').val(),
            kelas_id: $('#filter_kelas').val(),
            jurusan_id: $('#filter_jurusan').val(),
            agama_id: $('#filter_agama').val()
        };

        if (!ujianId) return;

        $.get(`<?= base_url('panel/ujian/filter-peserta') ?>/${ujianId}`, data, function(res) {
            $('#list-belum').empty();
            if (res.status) {
                $.each(res.data, function(i, peserta) {
                    $('#list-belum').append(`<option value="${peserta.id}">${peserta.nama} (${peserta.nisn})</option>`);
                });
            }
            updateCounts(); // ✅ di sini
        }, 'json');
    }


    // Ambil peserta yang sudah ditambahkan ke ujian
    function loadPesertaSudahDitambahkan(ujianId) {
        $.get(`<?= base_url('panel/ujian/peserta-ujian') ?>/${ujianId}`, function(res) {
            $('#list-sudah').empty();
            if (res.status) {
                $.each(res.data, function(i, peserta) {
                    $('#list-sudah').append(
                        `<option value="${peserta.id}" selected>${peserta.nama} (${peserta.nisn})</option>`
                    );
                });
            }
            updateCounts(); // ✅ di sini
        }, 'json');
    }

    function updateCounts() {
        $('#count-belum').text($('#list-belum option').length);
        $('#count-sudah').text($('#list-sudah option').length);
    }
</script>

<?php $this->endSection(); ?>