<?= $this->extend('Layout/main'); ?>
<?= $this->section('content'); ?>

<div class="layout-px-spacing">
    <div class="middle-content container-xxl p-0">
        <div class="layout-top-spacing">
            <div class="card shadow-sm border-0">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">🔄 Sinkronisasi Data</h5>
                </div>
                <div class="card-body">
                    <!-- Pusatkan input dan tombol -->
                    <div class="row justify-content-center mb-3">
                        <div class="col-md-6">
                            <label for="urlInput" class="form-label fw-semibold">URL Server Pusat</label>
                            <input type="text" id="urlInput" class="form-control" placeholder="Contoh: https://pusat.example.com" />
                        </div>
                    </div>

                    <div class="row justify-content-center">
                        <div class="col-md-6">
                            <label for="tokenInput" class="form-label fw-semibold">Token Akses</label>
                            <div class="input-group">
                                <input type="text" id="tokenInput" class="form-control" placeholder="Masukkan token..." />
                                <button class="btn btn-outline-primary" type="button" id="cekTokenBtn">
                                    <i data-feather="wifi"></i> Cek Koneksi
                                </button>
                            </div>
                        </div>
                    </div>

                    <div class="row justify-content-center mt-3">
                        <div class="col-auto">
                            <button id="syncBtn" class="btn btn-primary" disabled>
                                <i data-feather="refresh-cw"></i> Sinkronisasi Sekarang
                            </button>
                        </div>
                    </div>

                    <div class="mt-4" id="syncResultBox" style="display: none;">
                        <div class="card border-0 shadow-sm">
                            <div class="card-header bg-white fw-semibold">
                                ✅ Hasil Sinkronisasi
                            </div>
                            <div class="card-body p-0">
                                <div class="table-responsive">
                                    <table class="table table-striped mb-0" id="syncResultTable">
                                        <thead class="table-light">
                                            <tr>
                                                <th>Nama Data</th>
                                                <th class="text-end">Jumlah Tersimpan</th>
                                            </tr>
                                        </thead>
                                        <tbody></tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>


<?= $this->endSection(); ?>

<?= $this->section('pagejs'); ?>
<script>
    feather.replace();

    // Cek localStorage saat halaman dimuat
    const savedToken = localStorage.getItem('syncToken');
    const savedUrl = localStorage.getItem('syncServerUrl');

    if (savedToken) {
        $('#tokenInput').val(savedToken);
        // $('#syncBtn').prop('disabled', false).data('token', savedToken);
    }
    if (savedUrl) {
        $('#urlInput').val(savedUrl);
    }

    // Loading icon
    const loadingIcon = `<span class="spinner-border spinner-border-sm me-1" role="status" aria-hidden="true"></span>`;

    $('#cekTokenBtn').on('click', function() {
        const token = $('#tokenInput').val().trim();
        const url = $('#urlInput').val().trim();

        if (!url) {
            Swal.fire('URL Kosong', 'Harap isi URL server pusat.', 'warning');
            return;
        }

        if (!token) {
            Swal.fire('Token Kosong', 'Harap isi token terlebih dahulu.', 'warning');
            return;
        }

        $('#cekTokenBtn').prop('disabled', true).html(loadingIcon + 'Mengecek...');

        $.ajax({
            url: `${url}/api/sinkronisasi?token=${token}`,
            type: 'GET',
            dataType: 'json',
            success: function(res) {
                if (res.success) {
                    localStorage.setItem('syncToken', token);
                    localStorage.setItem('syncServerUrl', url);
                    // Simpan ke database lokal
                    $.post('<?= base_url('panel/sinkronisasi/simpan_koneksi') ?>', {
                        token: token,
                        url: url
                    }, function(response) {
                        console.log('Koneksi disimpan:', response);
                    }).fail(function() {
                        console.warn('Gagal menyimpan koneksi ke database lokal.');
                    });

                    Swal.fire({
                        icon: 'success',
                        title: 'Terhubung!',
                        text: 'Server merespons. Anda dapat melanjutkan sinkronisasi.'
                    });

                    $('#syncBtn').prop('disabled', false).data('token', token).data('url', url);
                } else {
                    Swal.fire('Token Tidak Valid', 'Token salah atau server tidak merespons.', 'error');
                }
            },
            error: function() {
                Swal.fire('Gagal Menghubungi', 'Periksa koneksi atau endpoint server.', 'error');
            },
            complete: function() {
                $('#cekTokenBtn').prop('disabled', false).html('<i data-feather="wifi"></i> Cek Koneksi');
                feather.replace();
            }
        });
    });

    $('#syncBtn').on('click', function() {
        const token = $(this).data('token');
        const url = $(this).data('url');

        Swal.fire({
            title: 'Pilih Data yang Akan Disinkronkan',
            html: `
        <div class="text-start mb-3">
            <label><input type="checkbox" class="sync-option" value="peserta"> Peserta (termasuk kelas, jurusan, tingkat, agama)</label><br>
            <label><input type="checkbox" class="sync-option" value="banksoal"> Bank Soal (termasuk soal dan opsi soal)</label><br>
            <label><input type="checkbox" class="sync-option" value="jadwal"> Jadwal Ujian (termasuk ujian dan hasil ujian)</label>
        </div>
        <div class="alert alert-warning small text-start" role="alert">
            <i class="me-1 text-warning" data-feather="alert-triangle"></i>
            <strong>Perhatian:</strong> Data lokal yang dipilih akan dihapus dan digantikan oleh data dari server.
        </div>
    
        `,
            showCancelButton: true,
            confirmButtonText: 'Lanjut Sinkronisasi',
            preConfirm: () => {
                const selected = [];
                document.querySelectorAll('.sync-option:checked').forEach(cb => selected.push(cb.value));
                if (selected.length === 0) {
                    Swal.showValidationMessage('Pilih setidaknya satu data untuk disinkronkan');
                }
                return selected;
            }
        }).then((result) => {
            if (!result.isConfirmed) return;

            const pilihan = result.value; // array of ['peserta', 'banksoal', 'jadwal']

            $('#syncBtn').prop('disabled', true).html(loadingIcon + 'Sinkronisasi...');
            $('#syncResultBox').hide();

            $.ajax({
                url: '<?= base_url('/panel/sinkronisasi/proses') ?>',
                type: 'POST',
                data: {
                    token: token,
                    url: url,
                    sinkronisasi: pilihan
                },
                dataType: 'json',
                success: function(res) {
                    const tableBody = $('#syncResultTable tbody');
                    tableBody.empty();

                    if (res.success) {
                        Object.entries(res.data).forEach(([key, value]) => {
                            const displayName = key.replace(/_/g, ' ').toLowerCase();
                            const count = Array.isArray(value) ? value.length : (value ?? 0);
                            const gagalCount = res.gagal && res.gagal[key] ? res.gagal[key].length : 0;

                            let badge = '';
                            if (gagalCount > 0) {
                                badge = ` <span class="badge bg-danger">Gagal: ${gagalCount}</span>`;
                            }

                            const row = `<tr>
                            <td class="text-capitalize">${displayName}</td>
                            <td class="text-end">${count} ${badge}</td>
                        </tr>`;
                            tableBody.append(row);
                        });

                        $('#syncResultBox').slideDown();
                        Swal.fire({
                            icon: 'success',
                            title: 'Sinkronisasi Berhasil',
                            html: 'Data berhasil diperbarui.<br>Periksa baris dengan badge merah untuk data yang gagal.'
                        });
                    } else {
                        Swal.fire('Sinkronisasi Gagal', res.message || 'Terjadi kesalahan saat memproses data.', 'error');
                    }
                },
                error: function() {
                    Swal.fire('Kesalahan Server', 'Terjadi error saat proses sinkronisasi.', 'error');
                },
                complete: function() {
                    $('#syncBtn').prop('disabled', false).html('<i data-feather="refresh-cw"></i> Sinkronisasi Sekarang');
                    feather.replace();
                }
            });
        });
    });
</script>
<?= $this->endSection(); ?>