<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <title>Cetak QR Code Server</title>
    <style>
        @media print {
            .page-break {
                page-break-after: always;
            }

            body {
                margin: 0;
            }
        }

        body {
            font-family: Arial, sans-serif;
            text-align: center;
            margin: 0;
            padding: 0;
        }

        .qr-page {
            width: 100vw;
            height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            flex-direction: column;
            page-break-inside: avoid;
        }

        h1,
        h2 {
            margin: 10px 0;
        }

        img.qr {
            margin-top: 20px;
            width: 400px;
            height: 400px;
        }

        .qr-container {
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            height: 100vh;
            border: 5px solid #2F539B;
            /* Tambahkan border hitam */
            padding: 40px;
            box-sizing: border-box;
        }
    </style>
</head>

<body>
    <?php for ($i = 1; $i <= $jumlah_ruang; $i++): ?>
        <div class="qr-container">
            <img src="<?= base_url('assets/img/') . $setting->logo ?>" width="100">
            <h1><?= esc($setting->nama_sekolah) ?></h1>
            <h2><?= esc($nama_ujian) ?></h2>
            <h1>Ruang <?= $i ?></h1>
            <img class="qr" src="<?= $qr_code->getDataUri() ?>" alt="QR Code Server">
        </div>
        <?php if ($i < $jumlah_ruang): ?>
            <div class="page-break"></div>
        <?php endif; ?>
    <?php endfor; ?>

    <script>
        window.onload = function() {
            window.print();
        };

        window.onafterprint = function() {
            window.close();
        };
    </script>

</body>

</html>