<!-- File: app/Views/Panel/kartu_peserta_config.php -->
<?= $this->extend('Layout/main') ?>
<?= $this->section('content') ?>

<div class="layout-px-spacing">
    <div class="middle-content container-xxl p-0">
        <div class="layout-top-spacing">
            <div class="widget widget-three">
                <form class="form-horizontal" id="form-kartu">
                    <div class="widget-heading d-flex justify-content-between align-items-center">
                        <h5 class="">Konfigurasi Kartu Peserta</h5>
                        <div class="task-action">
                            <button type="submit" class="btn btn-primary"><i data-feather="eye"></i> Preview</button>
                            <button type="button" id="btnPrint" class="btn btn-success ms-2"><i data-feather="printer"></i> Cetak</button>
                        </div>
                    </div>

                    <div class="widget-content">
                        <div class="form-group row mb-3">
                            <label for="nama_ujian" class="col-sm-3 col-form-label text-end">Nama Ujian</label>
                            <div class="col-sm-9">
                                <input type="text" name="nama_ujian" id="nama_ujian" class="form-control form-control-sm" required>
                            </div>
                        </div>

                        <div class="form-group row mb-3">
                            <label for="kelas_id" class="col-sm-3 col-form-label text-end">Kelas</label>
                            <div class="col-sm-9">
                                <select name="kelas_id" id="kelas_id" class="form-control form-control-sm" required>
                                    <option value="">-- Pilih Kelas --</option>
                                    <?php foreach ($kelas as $k) : ?>
                                        <option value="<?= $k['id'] ?>"><?= esc($k['nama']) ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                    </div>
                </form>

                <div class="widget-content mt-4">
                    <h6>Preview Kartu Peserta</h6>
                    <div id="preview-container">
                        <div class="alert alert-info">Silakan isi form dan klik Preview untuk menampilkan contoh kartu peserta.</div>
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>

<?= $this->endSection() ?>

<?= $this->section('pagejs'); ?>
<script>
    $(document).ready(function() {
        $('#form-kartu').on('submit', function(e) {
            e.preventDefault();
            const formData = $(this).serialize();

            $.ajax({
                url: "<?= site_url('panel/kartu/preview') ?>",
                type: "POST",
                data: formData,
                success: function(html) {
                    $('#preview-container').html(html);
                },
                error: function() {
                    alert("Gagal memuat preview kartu.");
                }
            });
        });

        $('#btnPrint').on('click', function() {
            const namaUjian = $('#nama_ujian').val();
            const kelasId = $('#kelas_id').val();

            if (!namaUjian || !kelasId) {
                alert('Nama ujian dan kelas wajib diisi.');
                return;
            }

            const url = `<?= site_url('panel/kartu/print') ?>?nama_ujian=${encodeURIComponent(namaUjian)}&kelas_id=${encodeURIComponent(kelasId)}`;
            window.open(url, '_blank');
        });
    });
</script>
<?= $this->endSection() ?>