<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <title>Cetak Soal - <?= esc($bankSoal['nama']) ?></title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 14px;
            margin: 40px;
        }

        h2 {
            text-align: center;
        }

        .soal {
            margin-bottom: 20px;
        }

        .opsi {
            margin-left: 20px;
        }

        .opsi div {
            margin: 3px 0;
        }

        .topik {
            font-style: italic;
            font-size: 13px;
            color: #555;
        }

        hr {
            margin: 30px 0;
        }
    </style>
</head>

<body>

    <h2>Bank Soal: <?= esc($bankSoal['nama']) ?></h2>

    <?php foreach ($soalList as $i => $soal): ?>
        <div class="soal">
            <div class="topik"><?= ($i + 1) ?>. Topik: <?= esc($soal['topik']['nama'] ?? '-') ?> | Jenis: <?= esc(strtoupper($soal['jenis_soal'])) ?></div>
            <div><strong> <?= $soal['pertanyaan'] ?></strong></div>

            <?php if (in_array($soal['jenis_soal'], ['pg', 'mpg', 'benar_salah', 'jodohkan'])): ?>
                <div class="opsi">
                    <?php foreach ($soal['opsi'] as $opsi): ?>
                        <div><strong><?= esc($opsi['label']) ?>.</strong> <?= esc(strip_tags($opsi['teks'])) ?>
                            <?php if ($soal['jenis_soal'] === 'jodohkan' && $opsi['pasangan']): ?>
                                — <em><?= esc($opsi['pasangan']) ?></em>
                            <?php endif; ?>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>

            <?php if (in_array($soal['jenis_soal'], ['isian', 'esai'])): ?>
                <div class="opsi" style="margin-top: 10px;">
                    <em>Jawaban:</em>
                    <div style="border: 1px solid #ccc; padding: 10px; min-height: 30px;">
                        <?= esc(strip_tags($soal['jawaban'])) ?>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    <?php endforeach; ?>
    <script>
        window.onload = function() {
            window.print();

            // Tunggu proses print selesai atau dibatalkan
            window.onafterprint = function() {
                window.close();
            };
        };
    </script>

</body>

</html>