<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Login Akun</title>
    <link href="<?= base_url() ?>src/bootstrap/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
    <link href="<?= base_url() ?>src/plugins/src/notification/snackbar/snackbar.min.css" rel="stylesheet" type="text/css" />

    <style>
        @font-face {
            font-family: 'Nunito';
            src: url('/assets/fonts/nunito/Nunito-VariableFont_wght.ttf') format('truetype');
        }

        body.form {
            font-family: 'Nunito', sans-serif;
            min-height: 100vh;
            background: linear-gradient(135deg, #e0f7fa, #ffffff);
            position: relative;
            overflow: hidden;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .bg-watermark {
            position: fixed;
            width: 200px;
            opacity: 0.05;
            z-index: 1;
            pointer-events: none;
            transition: all 3s ease-in-out;
            /* biar halus pas pindah */
        }



        .card.login-card {
            border-radius: 1.5rem;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.1);
            border: none;
            background: #fff;
            animation: fadeInUp 0.8s ease;
            position: relative;
            z-index: 2;
        }

        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(40px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        h2.fw-bold {
            background: linear-gradient(90deg, #5C6AC4, #9C6ADE);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            animation: glowText 2s ease-in-out infinite alternate;
        }

        @keyframes glowText {
            from {
                text-shadow: 0 0 5px rgba(92, 106, 196, 0.4);
            }

            to {
                text-shadow: 0 0 15px rgba(156, 106, 222, 0.8);
            }
        }

        .btn-gradient {
            background: linear-gradient(90deg, #5C6AC4, #9C6ADE);
            border: none;
            color: #fff;
            transition: all 0.3s ease;
        }

        .btn-gradient:hover {
            transform: scale(1.05);
            background: linear-gradient(90deg, #4a57b3, #845ec2);
        }

        /* Input animasi */
        .form-group {
            position: relative;
            margin-bottom: 1.5rem;
        }

        .form-control {
            border-radius: 50px;
            padding: 0.9rem 1.2rem;
            border: 2px solid #ddd;
            transition: all 0.3s ease;
            background: #f9f9f9;
        }

        .form-control:focus {
            border-color: #5C6AC4;
            background: #fff;
            box-shadow: 0 0 0 4px rgba(92, 106, 196, 0.15);
            transform: scale(1.02);
        }

        /* Label animasi floating */
        .form-group label {
            position: absolute;
            top: 50%;
            left: 20px;
            transform: translateY(-50%);
            transition: 0.3s ease;
            color: #aaa;
            pointer-events: none;
        }

        .form-control:focus+label,
        .form-control:not(:placeholder-shown)+label {
            top: -10px;
            left: 15px;
            font-size: 0.8rem;
            background: #fff;
            padding: 0 5px;
            color: #5C6AC4;
        }

        .btn-register {
            color: #5C6AC4;
            font-weight: bold;
            transition: 0.3s;
        }

        .btn-register:hover {
            color: #9C6ADE;
            text-decoration: underline;
        }

        /* Bubble Container */
        .bubbles {
            position: fixed;
            width: 100%;
            height: 100%;
            top: 0;
            left: 0;
            overflow: hidden;
            z-index: 0;
            /* di belakang card */
            pointer-events: none;
        }

        /* Bubble Style */
        .bubbles span {
            position: absolute;
            bottom: -100px;
            background: rgba(92, 106, 196, 0.15);
            border-radius: 50%;
            opacity: 0.6;
            animation: bubbleUp 12s linear infinite;
        }

        /* Random ukuran & posisi */
        .bubbles span:nth-child(1) {
            left: 10%;
            width: 40px;
            height: 40px;
            animation-duration: 10s;
        }

        .bubbles span:nth-child(2) {
            left: 20%;
            width: 25px;
            height: 25px;
            animation-duration: 12s;
        }

        .bubbles span:nth-child(3) {
            left: 35%;
            width: 60px;
            height: 60px;
            animation-duration: 18s;
        }

        .bubbles span:nth-child(4) {
            left: 50%;
            width: 20px;
            height: 20px;
            animation-duration: 14s;
        }

        .bubbles span:nth-child(5) {
            left: 65%;
            width: 45px;
            height: 45px;
            animation-duration: 16s;
        }

        .bubbles span:nth-child(6) {
            left: 80%;
            width: 30px;
            height: 30px;
            animation-duration: 20s;
        }

        .bubbles span:nth-child(7) {
            left: 90%;
            width: 50px;
            height: 50px;
            animation-duration: 22s;
        }

        /* Bubble animasi */
        @keyframes bubbleUp {
            0% {
                transform: translateY(0) scale(1);
                opacity: 0.6;
            }

            50% {
                opacity: 0.3;
            }

            100% {
                transform: translateY(-120vh) scale(1.2);
                opacity: 0;
            }
        }

        .custom-select {
            position: relative;
            width: 100%;
            border-radius: 50px;
            border: 2px solid #ddd;
            background: #f9f9f9;
            padding: 0.9rem 1.2rem;
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .select-trigger {
            display: flex;
            align-items: center;
            justify-content: space-between;
        }

        .options {
            position: absolute;
            top: 100%;
            left: 0;
            right: 0;
            background: #fff;
            border-radius: 15px;
            margin-top: 5px;
            box-shadow: 0 8px 20px rgba(0, 0, 0, 0.1);
            max-height: 0;
            overflow: hidden;
            opacity: 0;
            transition: all 0.3s ease;
        }

        .options.show {
            max-height: 200px;
            opacity: 1;
        }

        .option {
            padding: 10px 15px;
            transition: background 0.2s ease;
        }

        .option:hover {
            background: #f0f0ff;
        }
    </style>
</head>

<body class="form">

    <!-- Watermark random di background -->
    <!-- Watermark random di background -->
    <img src="<?= base_url('assets/img/logo_exam_1.png') ?>"
        class="bg-watermark" id="watermark" alt="Watermark">


    <!-- Bubble Background -->
    <div class="bubbles">
        <span></span>
        <span></span>
        <span></span>
        <span></span>
        <span></span>
        <span></span>
        <span></span>
    </div>

    <div class="container">
        <div class="row justify-content-center">
            <div class="col-xxl-4 col-xl-5 col-lg-6 col-md-8">
                <div class="card login-card">
                    <div class="card-body p-4">
                        <form id="loginForm" class="needs-validation" novalidate>
                            <div class="text-center mb-4">
                                <img src="<?= base_url('assets/img/') . $setting->logo ?>" alt="Logo" style="width: 80px; height: 80px;" class="mb-3">
                                <h2 class="fw-bold">Masuk Akun</h2>
                                <p class="text-muted mb-0">Silahkan masukan username dan password</p>
                            </div>

                            <div class="form-group">
                                <input type="text" name="identity" class="form-control" placeholder=" " required>
                                <label>Username</label>
                                <div class="invalid-feedback">Wajib diisi.</div>
                            </div>

                            <!-- Password (opsional) -->
                            <?php
                            $noPassword = !empty($exambroSetting['login_nopassword']) && $exambroSetting['login_nopassword'];
                            ?>
                            <div class="form-group mb-3 password-group"
                                style="<?= $noPassword ? 'display:none;' : '' ?>">
                                <label class="form-label">Password</label>
                                <input type="password" name="password" class="form-control"
                                    <?= $noPassword ? '' : 'required' ?>>
                                <div class="invalid-feedback">Wajib diisi.</div>
                            </div>

                            <div class="custom-select mb-3">
                                <div class="select-trigger">👨‍🎓 Pilih Role</div>
                                <div class="options">
                                    <div class="option" data-value="siswa">Siswa</div>
                                    <!-- <div class="option" data-value="guru">Guru</div> -->
                                </div>
                                <input type="hidden" name="role">
                            </div>

                            <!-- <div class="mb-3 form-check form-switch">
                                <input class="form-check-input" type="checkbox" id="ingat">
                                <label class="form-check-label" for="ingat">Ingat saya</label>
                            </div> -->

                            <button type="submit" class="btn btn-gradient btn-lg w-100 rounded-pill shadow-sm">Masuk</button>

                            <!-- <div class="text-center mt-3">
                                <p class="mb-0">Belum punya akun?
                                    <a href="<?= base_url('auth/register') ?>" class="btn-register">Daftar di sini</a>
                                </p>
                            </div> -->
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Scripts -->
    <script src="<?= base_url() ?>src/plugins/src/jquery/jquery-3.6.0.min.js"></script>
    <script src="<?= base_url() ?>src/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="<?= base_url() ?>src/plugins/src/notification/snackbar/snackbar.min.js"></script>
    <script>
        document.addEventListener("DOMContentLoaded", function() {
            const watermark = document.getElementById("watermark");
            const positions = [{
                    top: "5%",
                    left: "5%",
                    transform: "rotate(-15deg)"
                },
                {
                    top: "10%",
                    right: "8%",
                    transform: "rotate(10deg)"
                },
                {
                    bottom: "8%",
                    left: "10%",
                    transform: "rotate(20deg)"
                },
                {
                    bottom: "5%",
                    right: "5%",
                    transform: "rotate(-10deg)"
                }
            ];

            function moveWatermark() {
                const pos = positions[Math.floor(Math.random() * positions.length)];
                // Reset posisi lama
                watermark.style.top = watermark.style.bottom = "";
                watermark.style.left = watermark.style.right = "";
                // Apply posisi baru
                Object.assign(watermark.style, pos);
            }

            // Pertama kali
            moveWatermark();

            // Pindah setiap 6 detik
            setInterval(moveWatermark, 3000);
        });

        // JS untuk animasi buka/tutup
        document.querySelectorAll('.custom-select').forEach(select => {
            const trigger = select.querySelector('.select-trigger');
            const options = select.querySelector('.options');
            const hiddenInput = select.querySelector('input');

            trigger.addEventListener('click', () => {
                options.classList.toggle('show');
            });

            select.querySelectorAll('.option').forEach(opt => {
                opt.addEventListener('click', () => {
                    trigger.textContent = opt.textContent;
                    hiddenInput.value = opt.dataset.value;
                    options.classList.remove('show');
                });
            });
        });
    </script>

    <script>
        (function() {
            'use strict'
            const form = document.querySelector('.needs-validation');
            form.addEventListener('submit', function(event) {
                if (!form.checkValidity()) {
                    event.preventDefault();
                    event.stopPropagation();
                }
                form.classList.add('was-validated');
            }, false);
        })();

        $(document).ready(function() {
            $('#loginForm').on('submit', function(e) {
                e.preventDefault();

                let identity = $('[name="identity"]').val();
                let password = $('[name="password"]').length ? $('[name="password"]').val() : '';
                let role = $('[name="role"]').val();

                $.ajax({
                    url: "<?= base_url('auth/login') ?>",
                    method: "POST",
                    data: {
                        identity,
                        password,
                        role
                    },
                    dataType: "json",
                    success: function(res) {
                        if (res.status === 'success') {
                            window.location.href = res.redirect;
                        } else {
                            Snackbar.show({
                                text: res.message,
                                pos: 'top-center'
                            });
                        }
                    },
                    error: function() {
                        Snackbar.show({
                            text: 'Terjadi kesalahan koneksi.',
                            pos: 'top-center'
                        });
                    }
                });
            });
        });
    </script>
</body>

</html>