<?php

namespace App\Models;

use CodeIgniter\Model;

class UjianModel extends Model
{
    protected $table            = 'ujian';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = false;

    protected $returnType       = 'array';
    protected $useSoftDeletes   = false;

    protected $allowedFields = [
        'id',
        'bank_soal_id',
        'nama_ujian',
        'deskripsi',
        'kode_ujian',
        'token',
        'acak_soal',
        'acak_opsi',
        'pakai_token',
        'durasi_ujian',
        'minimal_durasi',
        'tampil_nilai',
        'tampil_pembahasan',
        'pakai_webcam',
        'perangkat_terkunci',
        'single_login',
        'created_by',
        'waktu_mulai',
        'waktu_selesai',
        'is_active',
        'butuh_login',
        'dibagikan',
        'created_at',
        'updated_at'
    ];

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    protected $validationRules    = [];
    protected $validationMessages = [];
    protected $skipValidation     = false;


    public function getAllUjian($userId = null)
    {
        $builder = $this->select('
            ujian.*,
            bank_soal.nama AS nama_bank_soal,
            COUNT(DISTINCT hasil_ujian.id) AS jumlah_peserta,
            COUNT(DISTINCT soal.id) AS jumlah_soal
        ')
            ->join('bank_soal', 'bank_soal.id = ujian.bank_soal_id')
            ->join('hasil_ujian', 'hasil_ujian.ujian_id = ujian.id', 'left')
            ->join('soal', 'soal.bank_soal_id = ujian.bank_soal_id', 'left')
            ->groupBy('ujian.id')
            ->orderBy('ujian.created_at', 'DESC');

        if ($userId !== null) {
            $builder->where('ujian.created_by', $userId);
        }

        return $builder->findAll();
    }
    public function getJadwalUjianTerdekat($userId = null)
    {
        $builder = $this->select('
            ujian.*,
            bank_soal.nama AS nama_bank_soal
        ')
            ->join('bank_soal', 'bank_soal.id = ujian.bank_soal_id')
            ->where('ujian.is_active', 1)
            // ->where('ujian.waktu_mulai >', date('Y-m-d H:i:s'))
            ->orderBy('ujian.waktu_mulai', 'ASC')
            ->limit(5);

        if ($userId !== null) {
            $builder->where('ujian.created_by', $userId);
        }

        return $builder->findAll();
    }


    public function getAllPeserta($pesertaId)
    {
        return $this->select('ujian.id, ujian.bank_soal_id, ujian.nama_ujian, ujian.kode_ujian, 
                            ujian.acak_soal, ujian.acak_opsi, ujian.pakai_token, ujian.durasi_ujian, 
                            ujian.minimal_durasi, ujian.tampil_nilai, ujian.tampil_pembahasan, ujian.pakai_webcam, 
                            ujian.perangkat_terkunci, ujian.waktu_mulai, ujian.waktu_selesai, ujian.is_active, 
                            ujian.created_at, ujian.updated_at, bank_soal.nama as nama_bank_soal, hasil_ujian.device_id')
            ->join('bank_soal', 'bank_soal.id = ujian.bank_soal_id')
            ->join('hasil_ujian', 'hasil_ujian.ujian_id = ujian.id', 'left')
            ->where('hasil_ujian.peserta_id', $pesertaId)
            ->groupBy('ujian.id')
            ->orderBy('ujian.created_at', 'DESC')
            ->findAll();
    }
    public function getWithNamaMapel($id)
    {
        return $this->select('ujian.*, bank_soal.nama as nama_mapel')
            ->join('bank_soal', 'bank_soal.id = ujian.bank_soal_id', 'left')
            ->where('ujian.id', $id)
            ->first();
    }
}
