<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CreatePesertaTable extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id'           => ['type' => 'CHAR', 'constraint' => 36, 'null' => false],
            'nama'         => ['type' => 'VARCHAR', 'constraint' => 255],
            'nisn'         => ['type' => 'VARCHAR', 'constraint' => 20, 'unique' => true],
            'tingkat_id'   => ['type' => 'CHAR', 'constraint' => 36],
            'kelas_id'     => ['type' => 'CHAR', 'constraint' => 36],
            'jurusan_id'   => ['type' => 'CHAR', 'constraint' => 36, 'null' => true],
            'agama_id'     => ['type' => 'CHAR', 'constraint' => 36, 'null' => true],
            'username'     => ['type' => 'VARCHAR', 'constraint' => 100, 'null' => true],
            'password'     => ['type' => 'VARCHAR', 'constraint' => 255, 'null' => true],
            'api_token'     => ['type' => 'VARCHAR', 'constraint' => 255, 'null' => true],
            'is_active'    => ['type' => 'TINYINT', 'constraint' => 1, 'default' => 1],
            'last_login'   => ['type' => 'DATETIME', 'null' => true],
            'created_at'   => ['type' => 'DATETIME', 'null' => true],
            'updated_at'   => ['type' => 'DATETIME', 'null' => true],
        ]);
        $this->forge->addKey('id', true);
        $this->forge->createTable('peserta');
    }

    public function down()
    {
        $this->forge->dropTable('peserta');
    }
}
