<?php

namespace App\Controllers;

use App\Controllers\BaseController;

class SinkronisasiController extends BaseController
{
    public function index()
    {
        return view('Panel/Sinkronisasi/sinkronisasi_view', [
            'setting' => $this->appSetting(),
            'title'   => 'Sinkronisasi Data',
        ]);
    }

    public function proses()
    {
        $request = service('request');
        $token   = $request->getPost('token');
        $url     = $request->getPost('url');
        $opsi    = $request->getPost('sinkronisasi'); // array: ['peserta', 'banksoal', 'jadwal']

        if (!$token || !$url) {
            return $this->response->setJSON([
                'success' => false,
                'message' => 'Token dan URL tidak boleh kosong'
            ]);
        }

        try {
            $client = \Config\Services::curlrequest();
            $response = $client->get(rtrim($url, '/') . '/api/sinkronisasi', [
                'query'       => ['token' => $token],
                'http_errors' => false,
            ]);

            $body = json_decode($response->getBody(), true);
            if ($response->getStatusCode() !== 200 || !isset($body['success']) || !$body['success']) {
                return $this->response->setJSON([
                    'success' => false,
                    'message' => $body['message'] ?? 'Gagal mengambil data dari server pusat'
                ]);
            }

            $data  = $body['data'] ?? [];
            $gagal = [];
            $hasil = [];

            if (in_array('peserta', $opsi)) {
                $gagal['kelas']   = $this->simpanBatch(new \App\Models\KelasModel(), $data['kelas'] ?? []);
                $gagal['tingkat'] = $this->simpanBatch(new \App\Models\TingkatModel(), $data['tingkat'] ?? []);
                $gagal['jurusan'] = $this->simpanBatch(new \App\Models\JurusanModel(), $data['jurusan'] ?? []);
                $gagal['agama']   = $this->simpanBatch(new \App\Models\AgamaModel(), $data['agama'] ?? []);
                $gagal['peserta'] = $this->simpanBatch(new \App\Models\PesertaModel(), $data['peserta'] ?? [], 'nisn');

                $hasil['kelas']   = $data['kelas'] ?? [];
                $hasil['tingkat'] = $data['tingkat'] ?? [];
                $hasil['jurusan'] = $data['jurusan'] ?? [];
                $hasil['agama']   = $data['agama'] ?? [];
                $hasil['peserta'] = $data['peserta'] ?? [];
            }

            if (in_array('banksoal', $opsi)) {
                $gagal['users']       = $this->simpanBatch(new \App\Models\UserModel(), $data['users'] ?? [], 'username');
                $gagal['banksoal']    = $this->simpanBatch(new \App\Models\BankSoalModel(), $data['banksoal'] ?? []);
                $gagal['topik_soal']  = $this->simpanBatch(new \App\Models\TopikSoalModel(), $data['topik_soal'] ?? []);
                $gagal['soal']        = $this->simpanBatch(new \App\Models\SoalModel(), $data['soal'] ?? []);
                $gagal['soal_opsi']   = $this->simpanBatch(new \App\Models\SoalOpsiModel(), $this->flattenSoalOpsi($data['soal'] ?? []));

                $hasil['users']       = $data['users'] ?? [];
                $hasil['banksoal']    = $data['banksoal'] ?? [];
                $hasil['topik_soal']  = $data['topik_soal'] ?? [];
                $hasil['soal']        = $data['soal'] ?? [];
                $hasil['soal_opsi']   = $this->flattenSoalOpsi($data['soal'] ?? []);

                // Media file
                $gagal['media_files'] = $this->simpanBatch(new \App\Models\MediaFileModel(), $data['media_files'] ?? []);
                $hasil['media_files'] = $data['media_files'] ?? [];

                helper('filesystem');
                // $baseUploadPath = FCPATH . 'uploads/';
                $soalIds = array_column($data['soal'] ?? [], 'id');

                // Download media files
                foreach ($data['media_files'] ?? [] as $file) {
                    try {
                        $usedIn = $file['used_in_soal'] ?? null;
                        $path   = $file['path'] ?? null;

                        if (!$path || !$usedIn || !in_array($usedIn, $soalIds)) {
                            $gagal['media_files_skipped'][] = [
                                'file' => $file,
                                'reason' => 'Path kosong atau ID soal tidak cocok'
                            ];
                            continue;
                        }

                        $remoteUrl = rtrim($url, '/') . '/' . ltrim($path, '/');
                        $targetPath = FCPATH . $path;

                        $dir = dirname($targetPath);
                        if (!is_dir($dir)) {
                            mkdir($dir, 0755, true);
                        }

                        if (file_exists($targetPath)) {
                            $gagal['media_files_skipped'][] = [
                                'file' => $path,
                                'reason' => 'Sudah ada di lokal'
                            ];
                            continue;
                        }

                        // Ambil response dari remote server
                        $res = $client->get($remoteUrl, [
                            'http_errors' => false,
                            'sink' => false // ini penting agar getBody() adalah stream, bukan string
                        ]);

                        $statusCode = $res->getStatusCode();

                        if ($statusCode === 200) {
                            $bodyStream = $res->getBody();

                            if (is_string($bodyStream)) {
                                // Jika langsung string, pakai langsung
                                $bodyContent = $bodyStream;
                            } elseif (is_object($bodyStream) && method_exists($bodyStream, 'getContents')) {
                                // Jika stream object, ambil isinya
                                $bodyContent = $bodyStream->getContents();
                            } else {
                                // Jika null atau tidak bisa dibaca
                                $gagal['media_files_download'][] = [
                                    'file' => $path,
                                    'reason' => 'bodyStream null atau tidak valid',
                                    'body_type' => gettype($bodyStream)
                                ];
                                continue;
                            }


                            if (!is_dir(dirname($targetPath))) {
                                mkdir(dirname($targetPath), 0755, true);
                            }

                            if (!is_writable(dirname($targetPath))) {
                                $gagal['media_files_download'][] = [
                                    'file' => $path,
                                    'reason' => 'Target directory tidak writable',
                                    'dir' => dirname($targetPath)
                                ];
                                continue;
                            }

                            if (file_put_contents($targetPath, $bodyContent) !== false) {
                                $gagal['media_files_success'][] = [
                                    'file' => basename($path),
                                    'url' => $remoteUrl,
                                    'saved_to' => $targetPath,
                                    'size' => filesize($targetPath)
                                ];
                            } else {
                                $gagal['media_files_download'][] = [
                                    'file' => $path,
                                    'url' => $remoteUrl,
                                    'reason' => 'file_put_contents gagal',
                                    'target_path' => $targetPath
                                ];
                            }
                        } else {
                            $gagal['media_files_download'][] = [
                                'file' => basename($path),
                                'url' => $remoteUrl,
                                'status' => $statusCode,
                                'reason' => 'Gagal download',
                                'body_preview' => substr((string) $res->getBody(), 0, 300)
                            ];
                        }
                    } catch (\Throwable $e) {
                        $gagal['media_files_download'][] = [
                            'file' => $file['path'] ?? 'unknown',
                            'error' => $e->getMessage(),
                            'trace' => $e->getTraceAsString()
                        ];
                    }
                }
            }

            if (in_array('jadwal', $opsi)) {
                $gagal['ujian']        = $this->simpanBatch(new \App\Models\UjianModel(), $data['ujian'] ?? []);
                $gagal['hasil_ujian']  = $this->simpanBatch(new \App\Models\HasilUjianModel(), $data['hasil_ujian'] ?? []);

                $hasil['ujian']        = $data['ujian'] ?? [];
                $hasil['hasil_ujian']  = $data['hasil_ujian'] ?? [];
            }

            return $this->response->setJSON([
                'success' => true,
                'message' => 'Data berhasil disinkronisasi',
                'data'    => array_map(fn($v) => count($v ?? []), $hasil),
                'gagal'   => $gagal,
            ]);
        } catch (\Throwable $e) {
            return $this->response->setJSON([
                'success' => false,
                'message' => 'Terjadi kesalahan: ' . $e->getMessage()
            ]);
        }
    }



    public function simpan_koneksi()
    {
        $token = $this->request->getPost('token');
        $url   = $this->request->getPost('url');

        if (!$token || !$url) {
            return $this->response->setJSON([
                'success' => false,
                'message' => 'Token atau URL kosong.'
            ]);
        }

        $model = new \App\Models\SettingsModel();
        $model->settings_update(['id' => 1], [
            'api_token' => $token,
            'api_url'   => $url,
        ]);

        return $this->response->setJSON([
            'success' => true,
            'message' => 'Data koneksi disimpan.'
        ]);
    }

    private function simpanBatch($model, array $data, ?string $uniqueKey = null): array
    {
        $gagal = [];
        if (empty($data)) return $gagal;

        foreach ($data as $item) {
            try {
                $id = $item['id'] ?? null;

                // Jika ada uniqueKey, hapus duplikat berdasarkan key atau ID
                if ($uniqueKey && isset($item[$uniqueKey])) {
                    $model->where($uniqueKey, $item[$uniqueKey])->orWhere('id', $id)->delete(null, true);
                } elseif ($id) {
                    $model->where('id', $id)->delete(null, true);
                }

                $model->insert($item);
            } catch (\Throwable $e) {
                $gagal[] = [
                    'data'  => $item,
                    'error' => $e->getMessage(),
                ];
            }
        }

        return $gagal;
    }

    private function flattenSoalOpsi(array $soal): array
    {
        $opsi = [];
        foreach ($soal as $item) {
            if (!empty($item['opsi'])) {
                foreach ($item['opsi'] as $o) {
                    $opsi[] = $o;
                }
            }
        }
        return $opsi;
    }
}
