<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use Endroid\QrCode\Color\Color;
use Endroid\QrCode\Encoding\Encoding;
use Endroid\QrCode\ErrorCorrectionLevel;
use Endroid\QrCode\QrCode;
use Endroid\QrCode\Label\Label;
use Endroid\QrCode\Logo\Logo;
use Endroid\QrCode\RoundBlockSizeMode;
use Endroid\QrCode\Writer\PngWriter;
use Endroid\QrCode\Writer\ValidationException;





class QrGeneratorController extends BaseController
{

    public function index()
    {

        $setting = $this->appSetting();

        $qrImageUri = $this->qrserver();


        $data = [

            'setting' => $setting,
            'title' => 'Qr Generator',
            'qrImageUri' => $qrImageUri
        ];
        return view('Panel/QrGenerator/qr_generator_view', $data);
    }
    public function ujian()
    {

        $setting = $this->appSetting();

        $qrImageUri = $this->qrserver();


        $data = [

            'setting' => $setting,
            'title' => 'Qr Link Ujian',
            'qrImageUri' => $qrImageUri
        ];
        return view('Panel/QrGenerator/qr_generator_view_ujian', $data);
    }

    public function generate()
    {
        $link = $this->request->getPost('link_ujian');
        if ($link) {
            $serverUrl = $link;
        } else {
            $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https://' : 'http://';
            $host = gethostbyname(gethostname());
            $serverUrl = $protocol . $host . ':' . $_SERVER['SERVER_PORT'];
        }

        // $serverUrl   = $this->request->getPost('server_url') ?? site_url();
        $namaUjian   = $this->request->getPost('nama_ujian');
        $jumlahRuang = (int) $this->request->getPost('jumlah_ruang');
        $writer = new PngWriter();
        $encryptedUrl = encryptData($serverUrl);

        // Create QR code
        $qrCode = new QrCode(
            data: $encryptedUrl,
            encoding: new Encoding('UTF-8'),
            errorCorrectionLevel: ErrorCorrectionLevel::Low,
            size: 300,
            margin: 10,
            roundBlockSizeMode: RoundBlockSizeMode::Margin,
            foregroundColor: new Color(0, 0, 0),
            backgroundColor: new Color(255, 255, 255)
        );

        // Create generic logo
        $logo = new Logo(
            path: FCPATH . 'assets/img/' . $this->appSetting()->logo,
            resizeToWidth: 50,
            punchoutBackground: true
        );

        // Create generic label
        // $label = new Label(
        //     text: 'Qr Code Server',
        //     textColor: new Color(255, 0, 0)
        // );

        $result = $writer->write($qrCode, $logo);

        $setting = $this->appSetting();

        return view('Panel/QrGenerator/qr_print_view', [
            'qr_code'      => $result,
            'setting' => $setting,
            'nama_ujian'   => $namaUjian,
            'jumlah_ruang' => $jumlahRuang
        ]);
    }

    public function qrserver()
    {
        $serverUrl = base_url(); // Ini akan otomatis pakai http/https dan domain yang sesuai konfigurasi

        $writer = new PngWriter();
        $encryptedUrl = encryptData($serverUrl);

        $qrCode = new QrCode(
            data: $encryptedUrl,
            encoding: new Encoding('UTF-8'),
            errorCorrectionLevel: ErrorCorrectionLevel::Low,
            size: 300,
            margin: 10,
            roundBlockSizeMode: RoundBlockSizeMode::Margin,
            foregroundColor: new Color(0, 0, 0),
            backgroundColor: new Color(255, 255, 255)
        );

        $logo = new Logo(
            path: FCPATH . 'assets/img/' . $this->appSetting()->logo,
            resizeToWidth: 50,
            punchoutBackground: true
        );

        $label = new Label(
            text: $serverUrl,
            textColor: new Color(255, 0, 0)
        );

        $result = $writer->write($qrCode, $logo, $label);

        // Return sebagai image (Data URI)
        return $result->getDataUri();
    }
    public function qrujian()
    {
        $linkujian = $this->request->getGet('link');
        $writer = new PngWriter();
        $encryptedUrl = encryptData($linkujian);

        $qrCode = new QrCode(
            data: $encryptedUrl,
            encoding: new Encoding('UTF-8'),
            errorCorrectionLevel: ErrorCorrectionLevel::Low,
            size: 300,
            margin: 10,
            roundBlockSizeMode: RoundBlockSizeMode::Margin,
            foregroundColor: new Color(0, 0, 0),
            backgroundColor: new Color(255, 255, 255)
        );

        $logo = new Logo(
            path: FCPATH . 'assets/img/' . $this->appSetting()->logo,
            resizeToWidth: 50,
            punchoutBackground: true
        );

        // $label = new Label(
        //     text: $serverUrl,
        //     textColor: new Color(255, 0, 0)
        // );

        $result = $writer->write($qrCode, $logo);

        return $this->response->setJSON([
            'qr' => $result->getDataUri()
        ]);
    }
}
