<?php

namespace App\Controllers;

use App\Models\UjianModel;
use App\Models\PesertaModel;
use App\Models\SoalModel;
use App\Models\BankSoalModel;

class HomeController extends BaseController
{
    protected $ujianModel;
    protected $pesertaModel;
    protected $soalModel;
    protected $banksoalModel;

    public function __construct()
    {
        $this->ujianModel    = new UjianModel();
        $this->pesertaModel  = new PesertaModel();
        $this->soalModel     = new SoalModel();
        $this->banksoalModel     = new BankSoalModel();
    }

    /**
     * Halaman Maintenance
     */
    public function maintenance()
    {
        return view('maintenance');
    }

    /**
     * Halaman 404 Not Found
     */
    public function notFound()
    {
        return view('404notfound');
    }

    /**
     * Halaman Unauthorized / Tidak Diizinkan
     */
    public function unauthorized()
    {
        return view('unauthorized');
    }

    /**
     * Halaman Dashboard Panel
     */
    public function index()
    {
        $data = [
            'title'        => 'Dashboard',
            'setting'      => $this->appSetting(), // tetap digunakan jika ada informasi exambro
            'settingujian' => (object)[
                'total_ujian'     => $this->ujianModel->countAll(),
                'total_peserta'   => $this->pesertaModel->countAll(),
                'total_soal'      => $this->soalModel->countAll(),
                'total_bank_soal'      => $this->banksoalModel->countAll(),
                'jadwal_ujian'    => $this->ujianModel->getJadwalUjianTerdekat(), // array of objects
            ],
        ];
        return view('Panel/home', $data);
    }
}
