<?php

namespace App\Controllers\Api;

use App\Controllers\BaseController;
use App\Models\PesertaModel;
use App\Models\UjianModel;
use App\Models\BankSoalModel;
use App\Models\SoalModel;
use App\Models\SoalOpsiModel;
use App\Models\HasilUjianModel;
use App\Models\KelasModel;
use App\Models\TingkatModel;
use App\Models\JurusanModel;
use App\Models\AgamaModel;
use App\Models\MediaFileModel;
use App\Models\UserModel;
use App\Models\TopikSoalModel;

use CodeIgniter\RESTful\ResourceController;

class SinkronisasiApiController extends ResourceController
{
    protected $format = 'json';

    public function index()
    {
        $token = $this->request->getGet('token');

        // Validasi token
        if (!$token || !$this->isValidToken($token)) {
            return $this->respond([
                'success' => false,
                'message' => 'Token tidak valid',
                'data'    => null
            ], 401);
        }

        // Inisialisasi model
        $pesertaModel      = new PesertaModel();
        $ujianModel        = new UjianModel();
        $banksoalModel     = new BankSoalModel();
        $soalModel         = new SoalModel();
        $soalOpsiModel     = new SoalOpsiModel();
        $hasilUjianModel   = new HasilUjianModel();
        $kelasModel        = new KelasModel();
        $tingkatModel      = new TingkatModel();
        $jurusanModel      = new JurusanModel();
        $agamaModel        = new AgamaModel();
        $mediaFileModel    = new MediaFileModel();
        $userModel         = new UserModel();
        $topikSoalModel = new TopikSoalModel();

        // Ambil data peserta
        $peserta = $pesertaModel->findAll();

        // Ambil ID unik relasi dari peserta
        $kelasIds   = array_unique(array_column($peserta, 'kelas_id'));
        $tingkatIds = array_unique(array_column($peserta, 'tingkat_id'));
        $jurusanIds = array_unique(array_column($peserta, 'jurusan_id'));
        $agamaIds   = array_unique(array_column($peserta, 'agama_id'));

        // Ambil data relasi berdasarkan ID yang digunakan peserta
        $kelas   = !empty($kelasIds)   ? $kelasModel->whereIn('id', $kelasIds)->findAll()   : [];
        $tingkat = !empty($tingkatIds) ? $tingkatModel->whereIn('id', $tingkatIds)->findAll() : [];
        $jurusan = !empty($jurusanIds) ? $jurusanModel->whereIn('id', $jurusanIds)->findAll() : [];
        $agama   = !empty($agamaIds)   ? $agamaModel->whereIn('id', $agamaIds)->findAll()   : [];


        // Ambil data utama
        $ujian         = $ujianModel->findAll();
        $banksoal      = $banksoalModel->findAll();
        $soal          = $soalModel->findAll();
        $soalOpsi      = $soalOpsiModel->findAll();
        $hasilUjian    = $hasilUjianModel->findAll();
        $mediaFiles    = $mediaFileModel->findAll();
        // Ambil hanya user yang dipakai di banksoal.created_by
        $userIds = array_unique(array_column($banksoal, 'created_by'));
        $users = !empty($userIds) ? $userModel->whereIn('id', $userIds)->findAll() : [];
        $topikSoalIds = array_unique(array_column($soal, 'topik_soal_id'));
        $topikSoal    = !empty($topikSoalIds) ? $topikSoalModel->whereIn('id', $topikSoalIds)->findAll() : [];

        // Gabungkan opsi ke dalam soal
        $opsiBySoalId = [];
        foreach ($soalOpsi as $opsi) {
            $opsiBySoalId[$opsi['soal_id']][] = $opsi;
        }

        foreach ($soal as &$s) {
            $s['opsi'] = $opsiBySoalId[$s['id']] ?? [];
        }

        return $this->respond([
            'success' => true,
            'message' => 'Data sinkronisasi berhasil diambil',
            'data' => [
                'peserta'      => $peserta,
                'ujian'        => $ujian,
                'banksoal'     => $banksoal,
                'soal'         => $soal,
                'hasil_ujian'  => $hasilUjian,
                'kelas'        => $kelas,
                'tingkat'      => $tingkat,
                'jurusan'      => $jurusan,
                'agama'        => $agama,
                'media_files'  => $mediaFiles,
                'users'        => $users,
                'topik_soal'   => $topikSoal
            ]
        ]);
    }

    private function isValidToken($token)
    {
        $settingModel = new \App\Models\SettingsModel();
        $apiToken = $settingModel->where('id', '1')->get()->getFirstRow();

        if (!$apiToken) {
            return false;
        }

        return $token === $apiToken->api_token;
    }

    public function kirimujian()
    {
        $token = $this->request->getPost('token');
        $ujian_id = $this->request->getPost('ujian_id');
        $jsonData = $this->request->getPost('data');

        if (!$this->isValidToken($token)) {
            return $this->response->setJSON(['status' => false, 'message' => 'Token tidak valid']);
        }

        $hasilList = json_decode($jsonData, true);

        if (!$hasilList) {
            return $this->response->setJSON(['status' => false, 'message' => 'Data kosong atau rusak']);
        }

        $model = new \App\Models\HasilUjianModel();
        foreach ($hasilList as $hasil) {
            $existing = $model->where('id', $hasil['id'])->first();
            if ($existing) {
                $model->update($hasil['id'], $hasil);
            }
            // else {
            //     $model->insert($hasil);
            // }
        }

        return $this->response->setJSON(['status' => true, 'message' => 'Sinkronisasi berhasil']);
    }
}
